/*
 * Decompiled with CFR 0.152.
 */
package com.archytasit.jersey.multipart;

import com.archytasit.jersey.multipart.utils.HeadersUtils;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.jersey.message.internal.HttpDateFormat;
import org.glassfish.jersey.message.internal.HttpHeaderReader;

public class ContentDisposition {
    private String name;
    private String type;
    private String fileName;
    private Date creationDate;
    private Date modificationDate;
    private Date readDate;
    private long size = -1L;

    protected static ContentDisposition withFileName(String name, String fileName) {
        ContentDisposition contentDisposition = new ContentDisposition(name);
        contentDisposition.fileName = fileName;
        return contentDisposition;
    }

    public static ContentDisposition fromHeaderValues(String name, MultivaluedMap<String, String> headers) {
        if (headers != null && headers.getFirst((Object)"Content-Disposition".toLowerCase()) != null) {
            try {
                return ContentDisposition.fromHeaderValue(name, (String)headers.getFirst((Object)"Content-Disposition".toLowerCase()));
            }
            catch (ParseException e) {
                Logger.getLogger(HeadersUtils.class.getName()).log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
        return ContentDisposition.defaultValue(name);
    }

    protected static ContentDisposition fromHeaderValue(String name, String header) throws ParseException {
        Map parameters;
        HttpHeaderReader reader = HttpHeaderReader.newInstance((String)header);
        reader.hasNext();
        ContentDisposition cd = new ContentDisposition(name, reader.nextToken().toString());
        Map map = parameters = reader.hasNext() ? HttpHeaderReader.readParameters((HttpHeaderReader)reader, (boolean)true) : null;
        if (parameters != null) {
            cd.fileName = (String)parameters.get("filename");
            cd.creationDate = ContentDisposition.createDate((String)parameters.get("creation-date"));
            cd.modificationDate = ContentDisposition.createDate((String)parameters.get("modification-date"));
            cd.readDate = ContentDisposition.createDate((String)parameters.get("read-date"));
            cd.size = ContentDisposition.createLong((String)parameters.get("size"));
        }
        return cd;
    }

    public static ContentDisposition defaultValue(String name) {
        return new ContentDisposition(name);
    }

    private ContentDisposition(String name) {
        this(name, "form-data");
    }

    private ContentDisposition(String name, String type) {
        this.name = name;
        this.type = "form-data";
    }

    public String toString() {
        return this.toStringBuffer().toString();
    }

    protected StringBuilder toStringBuffer() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.type);
        this.addStringParameter(sb, "name", this.name);
        this.addStringParameter(sb, "filename", this.fileName);
        this.addDateParameter(sb, "creation-date", this.creationDate);
        this.addDateParameter(sb, "modification-date", this.modificationDate);
        this.addDateParameter(sb, "read-date", this.readDate);
        this.addLongParameter(sb, "size", this.size);
        return sb;
    }

    protected void addStringParameter(StringBuilder sb, String name, String p) {
        if (p != null) {
            sb.append("; ").append(name).append("=\"").append(p).append("\"");
        }
    }

    protected void addDateParameter(StringBuilder sb, String name, Date p) {
        if (p != null) {
            sb.append("; ").append(name).append("=\"").append(HttpDateFormat.getPreferredDateFormat().format(p)).append("\"");
        }
    }

    protected void addLongParameter(StringBuilder sb, String name, Long p) {
        if (p != -1L) {
            sb.append("; ").append(name).append('=').append(Long.toString(p));
        }
    }

    private static Date createDate(String value) throws ParseException {
        if (value == null) {
            return null;
        }
        return HttpDateFormat.getPreferredDateFormat().parse(value);
    }

    private static long createLong(String value) throws ParseException {
        if (value == null) {
            return -1L;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Error parsing size parameter of value, " + value, 0);
        }
    }
}

