/*
 * Decompiled with CFR 0.152.
 */
package com.archytasit.jersey.multipart;

import com.archytasit.jersey.multipart.BodyPart;
import com.archytasit.jersey.multipart.ContentDisposition;
import com.archytasit.jersey.multipart.parsers.StreamingPart;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;

public abstract class FormDataBodyPart<T>
extends BodyPart
implements Closeable {
    private final boolean isFormField;
    private String filename;
    private T storeEntity;
    private long contentLength = -1L;

    protected FormDataBodyPart(StreamingPart part, long contentLength, T storeEntity) {
        super(part.getFieldName(), part.getContentType(), part.getHeaders(), part.getContentDisposition());
        this.storeEntity = storeEntity;
        this.contentLength = contentLength;
        this.isFormField = part.isFormField();
        this.filename = part.getFileName();
    }

    protected FormDataBodyPart(String name, MediaType contentType, MultivaluedMap<String, String> headers, boolean isFormField, String filename, T storeEntity, long contentLength, ContentDisposition contentDisposition) {
        super(name, contentType, headers, contentDisposition);
        this.isFormField = isFormField;
        this.filename = filename;
        this.storeEntity = storeEntity;
        this.contentLength = contentLength;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public <T> T getEntity(Class<T> type) throws IOException {
        if (InputStream.class.isAssignableFrom(type)) {
            return (T)this.getInputStream();
        }
        if (this.storeEntity.getClass().isAssignableFrom(type)) {
            return this.storeEntity;
        }
        return null;
    }

    public abstract InputStream getInputStream() throws IOException;

    public boolean isFormField() {
        return this.isFormField;
    }

    public String getFilename() {
        return this.filename;
    }

    public T getStoreEntity() {
        return this.storeEntity;
    }
}

