/*
 * Decompiled with CFR 0.152.
 */
package com.archytasit.jersey.multipart;

import com.archytasit.jersey.multipart.exception.EntityTooLargeException;
import com.archytasit.jersey.multipart.utils.InputStreamLimitCounter;
import com.archytasit.jersey.multipart.utils.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.ext.Provider;
import org.apache.commons.io.output.NullOutputStream;

@Provider
public class MultiPartConfig {
    private String tempFileDirectory = System.getProperty("java.io.tmpdir");
    private String tempFilePrefix = "MULTIPART_";
    private int memorySizeLimit = 10240;
    private String tempFileSuffix = null;
    private Charset defaultCharset = Charset.forName("ISO-8859-1");
    private long requestSizeLimit = -1L;
    private CleanResourceMode cleanResourceMode = CleanResourceMode.ALWAYS;
    private Consumer<InputStream> requestSizeLimitAction = is -> {
        if (is != null) {
            try {
                StreamUtils.toOutStream(is, (OutputStream)new NullOutputStream());
            }
            catch (IOException e) {
                Logger.getLogger(InputStreamLimitCounter.class.getName()).log(Level.WARNING, "failed to read the remaining of request", e);
            }
        }
        throw new EntityTooLargeException();
    };

    public String getTempFileDirectory() {
        return this.tempFileDirectory;
    }

    public String getTempFilePrefix() {
        return this.tempFilePrefix;
    }

    public String getTempFileSuffix() {
        return this.tempFileSuffix;
    }

    public long getRequestSizeLimit() {
        return this.requestSizeLimit;
    }

    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    public int getMemorySizeLimit() {
        return this.memorySizeLimit;
    }

    public Consumer<InputStream> getRequestSizeLimitAction() {
        return this.requestSizeLimitAction;
    }

    public CleanResourceMode getCleanResourceMode() {
        return this.cleanResourceMode;
    }

    public MultiPartConfig cleanResourceMode(CleanResourceMode cleanResourceMode) {
        this.cleanResourceMode = cleanResourceMode;
        return this;
    }

    public MultiPartConfig requestSizeLimit(long requestSizeLimit) {
        this.requestSizeLimit = requestSizeLimit;
        return this;
    }

    public MultiPartConfig requestSizeLimitAction(Consumer<InputStream> requestSizeLimitAction) {
        this.requestSizeLimitAction = requestSizeLimitAction;
        return this;
    }

    public MultiPartConfig tempFileDirectory(String tempFileDirectory) {
        this.tempFileDirectory = tempFileDirectory;
        return this;
    }

    public MultiPartConfig tempFilePrefix(String tempFilePrefix) {
        this.tempFilePrefix = tempFilePrefix;
        return this;
    }

    public MultiPartConfig tempFileSuffix(String tempFileSuffix) {
        this.tempFileSuffix = tempFileSuffix;
        return this;
    }

    public MultiPartConfig defaultCharset(Charset defaultCharset) {
        this.defaultCharset = defaultCharset;
        return this;
    }

    public MultiPartConfig memorySizeLimit(int memorySizeLimit) {
        this.memorySizeLimit = memorySizeLimit;
        return this;
    }

    public static enum CleanResourceMode {
        ALWAYS,
        ON_ERROR,
        NEVER;

    }
}

