/*
 * Decompiled with CFR 0.152.
 */
package com.archytasit.jersey.multipart;

import com.archytasit.jersey.multipart.BodyPart;
import com.archytasit.jersey.multipart.ContentDisposition;
import com.archytasit.jersey.multipart.MultiPart;
import com.archytasit.jersey.multipart.MultiPartConfig;
import com.archytasit.jersey.multipart.bodypartproviders.IFormDataBodyPartProvider;
import com.archytasit.jersey.multipart.parsers.IRequestParser;
import com.archytasit.jersey.multipart.parsers.StreamingPart;
import com.archytasit.jersey.multipart.parsers.StreamingPartIterator;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.Consumes;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Providers;

@Consumes(value={"multipart/*"})
@Singleton
@ConstrainedTo(value=RuntimeType.CLIENT)
public class MultiPartMessageBodyReaderClient
implements MessageBodyReader<MultiPart> {
    private static final MediaType MULTIPART_WILDCARD = new MediaType("multipart", null);
    protected MultiPartConfig config;
    @Inject
    private IRequestParser requestParser;
    @Inject
    private IFormDataBodyPartProvider bodyPartProvider;

    @Inject
    public MultiPartMessageBodyReaderClient(@Context Providers providers) {
        this.config = this.getInstanceFromContext(providers, MultiPartConfig.class, MultiPartConfig::new);
    }

    private <T> T getInstanceFromContext(Providers providers, Class<T> clazz, Supplier<T> defaultValueSupplier) {
        ContextResolver contextResolver = providers.getContextResolver(clazz, MediaType.WILDCARD_TYPE);
        Object instance = null;
        if (contextResolver != null) {
            instance = contextResolver.getContext(this.getClass());
        }
        return (T)(instance != null ? instance : (Object)defaultValueSupplier.get());
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return mediaType.isCompatible(MediaType.MULTIPART_FORM_DATA_TYPE) && MultiPart.class.isAssignableFrom(type);
    }

    public MultiPart readFrom(Class<MultiPart> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        return this.readFromParent(null, mediaType, httpHeaders, entityStream);
    }

    public MultiPart readFromParent(String name, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        MultiPart multiPart = new MultiPart(name, mediaType, httpHeaders, ContentDisposition.fromHeaderValues(name, httpHeaders));
        StreamingPartIterator partIterator = this.requestParser.getPartIterator(mediaType, httpHeaders, entityStream);
        if (partIterator != null) {
            while (partIterator.hasNext()) {
                StreamingPart part = partIterator.next();
                if (MULTIPART_WILDCARD.isCompatible(part.getContentType())) {
                    String fieldName = name;
                    multiPart.add(this.readFromParent(fieldName, part.getContentType(), part.getHeaders(), part.getInputStream()));
                    continue;
                }
                multiPart.add((BodyPart)this.bodyPartProvider.provideBodyPart(this.config, part));
            }
        }
        return multiPart;
    }
}

