/*
 * Decompiled with CFR 0.152.
 */
package com.archytasit.jersey.multipart;

import com.archytasit.jersey.multipart.BodyPart;
import com.archytasit.jersey.multipart.MultiPart;
import com.archytasit.jersey.multipart.MultiPartMessageBodyReaderClient;
import com.archytasit.jersey.multipart.ResourceCleaner;
import com.archytasit.jersey.multipart.utils.InputStreamLimitCounter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.Consumes;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Providers;
import org.glassfish.jersey.server.ContainerRequest;

@Singleton
@ConstrainedTo(value=RuntimeType.SERVER)
@Consumes(value={"multipart/*"})
public class MultiPartMessageBodyReaderServer
extends MultiPartMessageBodyReaderClient {
    @Inject
    private ResourceCleaner resourceCleaner;
    @Context
    private Provider<ContainerRequest> requestProvider;

    @Inject
    public MultiPartMessageBodyReaderServer(@Context Providers providers) {
        super(providers);
    }

    @Override
    public MultiPart readFrom(Class<MultiPart> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        InputStream contentStream = entityStream;
        if (this.config.getRequestSizeLimit() > 0L) {
            contentStream = new InputStreamLimitCounter(this.config.getRequestSizeLimit(), entityStream, this.config.getRequestSizeLimitAction());
        }
        Object multiPart = super.readFrom((Class)type, genericType, annotations, mediaType, (MultivaluedMap)httpHeaders, contentStream);
        this.resourceCleaner.trackResourceToClean((BodyPart)multiPart, this.config.getCleanResourceMode(), (ContainerRequest)this.requestProvider.get());
        return multiPart;
    }
}

