/*
 * Decompiled with CFR 0.152.
 */
package com.archytasit.jersey.multipart;

import com.archytasit.jersey.multipart.BodyPart;
import com.archytasit.jersey.multipart.FormDataBodyPart;
import com.archytasit.jersey.multipart.MultiPart;
import com.archytasit.jersey.multipart.internal.MultiPartParameterConverterProvider;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.Providers;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.message.MessageUtils;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

@Singleton
@Produces(value={"multipart/*"})
public class MultiPartMessageBodyWriter
implements MessageBodyWriter<MultiPart> {
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    private final Providers providers;
    @Inject
    private MultiPartParameterConverterProvider paramConverterProvider;

    public MultiPartMessageBodyWriter(@Context Providers providers) {
        this.providers = providers;
    }

    public long getSize(MultiPart entity, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return MultiPart.class.isAssignableFrom(type);
    }

    public void writeTo(MultiPart entity, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> headers, OutputStream stream) throws IOException, WebApplicationException {
        String boundaryString = this.getOrGenerateBoundary(entity);
        this.normaliseHeaders(entity);
        entity.getHeaders().entrySet().forEach(e -> {
            headers.remove(e.getKey());
            headers.addAll(e.getKey(), new Object[]{e.getValue()});
        });
        headers.putSingle((Object)"Content-Type", (Object)entity.getContentType().toString());
        Object value = headers.getFirst((Object)"MIME-Version");
        if (value == null) {
            headers.putSingle((Object)"MIME-Version", (Object)"1.0");
        }
        this.writeMultiPart(entity, boundaryString, annotations, entity.getContentType(), headers, stream);
    }

    public void writeMultiPart(MultiPart entity, String boundaryString, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> headers, OutputStream stream) throws IOException, WebApplicationException {
        Object value;
        if (entity.getBodyParts() == null || entity.getBodyParts().size() < 1) {
            throw new IllegalArgumentException();
        }
        if (entity.getParent() == null && (value = headers.getFirst((Object)"MIME-Version")) == null) {
            headers.putSingle((Object)"MIME-Version", (Object)"1.0");
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream, MessageUtils.getCharset((MediaType)mediaType)));
        boolean isFirst = true;
        for (BodyPart bodyPart : entity.getBodyParts()) {
            String subBoundary = null;
            if (bodyPart instanceof MultiPart) {
                subBoundary = this.getOrGenerateBoundary((MultiPart)bodyPart);
            }
            this.normaliseHeaders(bodyPart);
            if (isFirst) {
                isFirst = false;
                writer.write("--");
            } else {
                writer.write("\r\n--");
            }
            writer.write(boundaryString);
            writer.write("\r\n");
            MediaType bodyMediaType = bodyPart.getContentType();
            if (bodyMediaType == null) {
                throw new IllegalArgumentException();
            }
            MultivaluedMap<String, String> bodyHeaders = bodyPart.getHeaders();
            for (Map.Entry entry : bodyHeaders.entrySet()) {
                writer.write((String)entry.getKey());
                ((Writer)writer).write(58);
                boolean first = true;
                for (String value2 : (List)entry.getValue()) {
                    if (first) {
                        ((Writer)writer).write(32);
                        first = false;
                    } else {
                        ((Writer)writer).write(44);
                    }
                    writer.write(value2);
                }
                writer.write("\r\n");
            }
            writer.write("\r\n");
            ((Writer)writer).flush();
            if (MultiPart.class.isAssignableFrom(bodyPart.getClass())) {
                MultiPart nestedMultiPart = (MultiPart)bodyPart;
                this.writeMultiPart(nestedMultiPart, subBoundary, annotations, nestedMultiPart.getContentType(), nestedMultiPart.getHeaders(), stream);
                continue;
            }
            if (FormDataBodyPart.class.isAssignableFrom(bodyPart.getClass())) {
                ParamConverter<?> paramConverter;
                Class<Object> genericBodyType;
                FormDataBodyPart formBodyPart = (FormDataBodyPart)bodyPart;
                Object bodyEntity = formBodyPart.getStoreEntity();
                if (bodyEntity == null) {
                    throw new IllegalArgumentException();
                }
                Class<Object> bodyClass = bodyEntity.getClass();
                MessageBodyWriter bodyWriter = this.providers.getMessageBodyWriter(bodyClass, genericBodyType = ReflectionHelper.getGenericTypeArgumentClasses(bodyClass).stream().findFirst().orElse(bodyClass), EMPTY_ANNOTATIONS, bodyMediaType);
                if (bodyWriter == null && (paramConverter = this.paramConverterProvider.getConverter(bodyClass, genericBodyType, null)) != null) {
                    bodyEntity = paramConverter.toString(bodyEntity);
                    bodyClass = String.class;
                    genericBodyType = String.class;
                    bodyWriter = this.providers.getMessageBodyWriter(bodyClass, genericBodyType, EMPTY_ANNOTATIONS, bodyMediaType);
                }
                if (bodyWriter != null) {
                    bodyWriter.writeTo(bodyEntity, bodyClass, genericBodyType, EMPTY_ANNOTATIONS, bodyMediaType, bodyHeaders, stream);
                    continue;
                }
                throw new IllegalArgumentException();
            }
            throw new NotImplementedException();
        }
        writer.write("\r\n--");
        writer.write(boundaryString);
        writer.write("--\r\n");
        ((Writer)writer).flush();
    }

    private String getOrGenerateBoundary(MultiPart entity) {
        String boundary = (String)entity.getContentType().getParameters().get("boundary");
        if (boundary == null || boundary.trim().length() == 0) {
            boundary = Stream.concat(Stream.of("boundary"), Stream.of(UUID.randomUUID().toString().replace('-', '_'))).collect(Collectors.joining("_"));
            entity.addContentTypeParameter("boundary", boundary);
        }
        return boundary;
    }

    private void normaliseHeaders(BodyPart entity) {
        if (entity.getContentDisposition() != null) {
            entity.getHeaders().putSingle((Object)"Content-Disposition", (Object)entity.getContentDisposition().toString());
        }
        entity.getHeaders().putSingle((Object)"Content-Type", (Object)entity.getContentType().toString());
    }
}

