/*
 * Decompiled with CFR 0.152.
 */
package com.archytasit.jersey.multipart;

import com.archytasit.jersey.multipart.BodyPart;
import com.archytasit.jersey.multipart.MultiPartConfig;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.glassfish.jersey.server.ContainerRequest;

public class ResourceCleaner {
    private static String REQUEST_FILES_LIST_PROPERTY_NAME = ResourceCleaner.class.getName();

    public void trackResourceToClean(BodyPart resourceToClean, MultiPartConfig.CleanResourceMode cleanMode, ContainerRequest request) {
        if (!cleanMode.equals((Object)MultiPartConfig.CleanResourceMode.NEVER)) {
            Map filesToClean = this.getOrCreateRequestProperty(request, REQUEST_FILES_LIST_PROPERTY_NAME, HashMap::new);
            if (filesToClean.get((Object)cleanMode) == null) {
                filesToClean.put(cleanMode, new HashSet());
            }
            ((Set)filesToClean.get((Object)cleanMode)).add(resourceToClean);
        }
    }

    public void cleanRequest(ContainerRequest request, boolean isSuccess) {
        Map filesToClean = (Map)request.getProperty(ResourceCleaner.class.getName());
        if (filesToClean != null) {
            ((Set)filesToClean.getOrDefault((Object)MultiPartConfig.CleanResourceMode.ALWAYS, new HashSet())).forEach(BodyPart::close);
            if (!isSuccess) {
                ((Set)filesToClean.getOrDefault((Object)MultiPartConfig.CleanResourceMode.ON_ERROR, new HashSet())).forEach(BodyPart::close);
            }
        }
    }

    private <T> T getOrCreateRequestProperty(ContainerRequest request, String propName, Supplier<T> newItem) {
        Object item = request.getProperty(propName);
        if (item == null) {
            item = newItem.get();
            request.setProperty(propName, item);
        }
        return (T)item;
    }
}

