/*
 * Decompiled with CFR 0.152.
 */
package com.archytasit.jersey.multipart.bodypartproviders;

import com.archytasit.jersey.multipart.FormDataBodyPart;
import com.archytasit.jersey.multipart.MultiPartConfig;
import com.archytasit.jersey.multipart.bodypartproviders.IFormDataBodyPartProvider;
import com.archytasit.jersey.multipart.parsers.StreamingPart;
import com.archytasit.jersey.multipart.utils.HeadersUtils;
import com.archytasit.jersey.multipart.utils.InputStreamCounter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.charset.Charset;

public class MemoryLimitBodyPartProvider
implements IFormDataBodyPartProvider {
    private Integer limitOverride = null;
    private IFormDataBodyPartProvider memoryProvider;
    private IFormDataBodyPartProvider largeObjectProvider;

    public MemoryLimitBodyPartProvider(Integer limitOverride, IFormDataBodyPartProvider memoryProvider, IFormDataBodyPartProvider largeObjectProvider) {
        this.limitOverride = limitOverride;
        if (memoryProvider == null || largeObjectProvider == null) {
            throw new IllegalArgumentException("memoryProvider and largeObjectProvider must not be null");
        }
        this.memoryProvider = memoryProvider;
        this.largeObjectProvider = largeObjectProvider;
    }

    public FormDataBodyPart provideBodyPart(MultiPartConfig config, StreamingPart streamingPart) throws IOException {
        byte[] memoryBytes;
        int limit = this.limitOverride != null ? this.limitOverride.intValue() : config.getMemorySizeLimit();
        Charset charset = HeadersUtils.getCharset(streamingPart.getContentType());
        if (charset == null) {
            charset = config.getDefaultCharset();
        }
        boolean swithToFile = false;
        InputStreamCounter inputStream = new InputStreamCounter(streamingPart.getInputStream());
        try (ByteArrayOutputStream outStream = new ByteArrayOutputStream();){
            byte[] buffer;
            int bytesRead;
            int currentBufferSite = Math.min(8192, limit >= 0 ? limit + 1 : 8192);
            while ((bytesRead = inputStream.read(buffer = new byte[currentBufferSite])) != -1) {
                outStream.write(buffer, 0, bytesRead);
                int alreadyRead = (int)inputStream.getContentRead();
                if (limit > 0 && limit < alreadyRead) {
                    swithToFile = true;
                    break;
                }
                currentBufferSite = Math.min(8192, limit - alreadyRead >= 0 ? limit - alreadyRead + 1 : 8192);
            }
            outStream.flush();
            memoryBytes = outStream.toByteArray();
        }
        var9_8 = null;
        try (ByteArrayInputStream stream = new ByteArrayInputStream(memoryBytes);){
            if (!swithToFile) {
                Object t = this.memoryProvider.provideBodyPart(config, this.overridePartStream(streamingPart, stream));
                return t;
            }
            Object t = this.largeObjectProvider.provideBodyPart(config, this.overridePartStream(streamingPart, new SequenceInputStream(stream, streamingPart.getInputStream())));
            return t;
        }
        catch (Throwable throwable) {
            var9_8 = throwable;
            throw throwable;
        }
    }

    private StreamingPart overridePartStream(StreamingPart part, InputStream stream) {
        return new StreamingPart(part.getFieldName(), part.getContentType(), part.getContentDisposition(), part.getHeaders(), part.isFormField(), part.getFileName(), stream);
    }
}

