/*
 * Decompiled with CFR 0.152.
 */
package com.archytasit.jersey.multipart.internal.valueproviders;

import com.archytasit.jersey.multipart.BodyPart;
import com.archytasit.jersey.multipart.FormDataBodyPart;
import com.archytasit.jersey.multipart.MultiPart;
import com.archytasit.jersey.multipart.annotations.FormDataParam;
import com.archytasit.jersey.multipart.internal.valueproviders.AbstractMultiPartValueProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.glassfish.jersey.model.Parameter;
import org.glassfish.jersey.server.ContainerRequest;

public abstract class AbstractBodyPartsValueProvider<T>
extends AbstractMultiPartValueProvider<T> {
    private String paramName;
    protected FormDataParam marker;
    protected Parameter parameter;
    private Predicate<FormDataBodyPart> partNatureFilter;

    public AbstractBodyPartsValueProvider(Parameter parameter) {
        this.parameter = parameter;
        this.marker = parameter.getSourceAnnotation().annotationType() == FormDataParam.class ? (FormDataParam)parameter.getSourceAnnotation() : (FormDataParam)parameter.getAnnotation(FormDataParam.class);
        this.paramName = this.marker.value();
        this.partNatureFilter = this.preparePartNatureFilter(this.marker.formDataType());
    }

    @Override
    protected final T apply(ContainerRequest request, MultiPart entity) {
        List<FormDataBodyPart> enhancedBodyParts = this.findFields(entity, this.paramName).stream().filter(this.partNatureFilter).collect(Collectors.toList());
        return this.applyToBodyParts(request, enhancedBodyParts);
    }

    private List<FormDataBodyPart> getNestedParts(BodyPart part) {
        ArrayList<FormDataBodyPart> result = new ArrayList<FormDataBodyPart>();
        if (FormDataBodyPart.class.isAssignableFrom(part.getClass())) {
            result.add((FormDataBodyPart)part);
        } else if (MultiPart.class.isAssignableFrom(part.getClass())) {
            ((MultiPart)part).getBodyParts().stream().map(this::getNestedParts).forEach(result::addAll);
        }
        return result;
    }

    private List<FormDataBodyPart> findFields(MultiPart entity, String ... names) {
        return entity.getBodyParts().stream().filter(Objects::nonNull).filter(p -> this.paramName.equals(p.getName())).filter(f -> FormDataBodyPart.class.isAssignableFrom(f.getClass())).map(this::getNestedParts).flatMap(Collection::stream).collect(Collectors.toList());
    }

    protected abstract T applyToBodyParts(ContainerRequest var1, List<FormDataBodyPart> var2);

    protected String getParameterName() {
        return this.paramName;
    }

    private Predicate<FormDataBodyPart> preparePartNatureFilter(FormDataParam.FormDataType filter) {
        switch (filter) {
            case FORMFIELD: {
                return FormDataBodyPart::isFormField;
            }
            case ATTACHMENT: {
                Predicate<FormDataBodyPart> predicate = FormDataBodyPart::isFormField;
                return predicate.negate();
            }
        }
        return b -> true;
    }
}

