/*
 * Decompiled with CFR 0.152.
 */
package com.archytasit.jersey.multipart.internal.valueproviders;

import com.archytasit.jersey.multipart.FormDataBodyPart;
import com.archytasit.jersey.multipart.annotations.Map;
import com.archytasit.jersey.multipart.internal.valueproviders.AbstractBodyPartsValueProvider;
import com.archytasit.jersey.multipart.internal.valueproviders.EnhancedBodyPart;
import com.archytasit.jersey.multipart.utils.HeadersUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.model.Parameter;
import org.glassfish.jersey.server.ContainerRequest;

public abstract class AbstractEnhancedBodyPartsValueProvider<T>
extends AbstractBodyPartsValueProvider<T> {
    private Predicate<EnhancedBodyPart> mediaTypeFilter;
    private Function<FormDataBodyPart, MediaType> mediaTypeConverter;
    private BiFunction<FormDataBodyPart, MediaType, EnhancedBodyPart.ValueExtractionMode> extractionModeSupplier;

    public AbstractEnhancedBodyPartsValueProvider(Parameter parameter) {
        super(parameter);
        this.mediaTypeConverter = this.prepareMediaTypeConverter(this.marker.mapContentTypeAs());
        this.mediaTypeFilter = this.prepareMediaTypeFilter(this.marker.filterContentType());
        this.extractionModeSupplier = this.prepareModeSupplier();
    }

    @Override
    protected final T applyToBodyParts(ContainerRequest request, List<FormDataBodyPart> bodyParts) {
        List<EnhancedBodyPart> enhancedBodyParts = bodyParts.stream().filter(Objects::nonNull).map(b -> {
            MediaType targetMediaType = this.mediaTypeConverter.apply((FormDataBodyPart)b);
            return new EnhancedBodyPart((FormDataBodyPart)b, targetMediaType, this.extractionModeSupplier.apply((FormDataBodyPart)b, targetMediaType));
        }).filter(this.mediaTypeFilter).collect(Collectors.toList());
        return this.applyToEnhancedBodyParts(request, enhancedBodyParts);
    }

    protected abstract T applyToEnhancedBodyParts(ContainerRequest var1, List<EnhancedBodyPart> var2);

    private Function<FormDataBodyPart, MediaType> prepareMediaTypeConverter(Map[] mappingsStr) {
        List mappings = Stream.of(mappingsStr).map(m -> {
            MediaType from = HeadersUtils.getMediaType(m.from());
            MediaType to = HeadersUtils.getMediaType(m.to());
            if (from == null || to == null) {
                Logger.getLogger(AbstractEnhancedBodyPartsValueProvider.class.getName()).log(Level.WARNING, String.format("ignored invalid media type in FormDataParam.Map : %s -> %s", m.from(), m.to()));
                return null;
            }
            return new Mapping(from, to);
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return b -> {
            MediaType mediaType = b.getContentType() != null ? b.getContentType() : MediaType.TEXT_PLAIN_TYPE;
            for (Mapping mapping : mappings) {
                if (!mediaType.isCompatible(mapping.from)) continue;
                return mapping.to;
            }
            return mediaType;
        };
    }

    private Predicate<EnhancedBodyPart> prepareMediaTypeFilter(String[] filterContentType) {
        Set allowedMediaTypes = Arrays.stream(filterContentType).filter(Objects::nonNull).map(s -> HeadersUtils.getMediaType(s)).filter(Objects::nonNull).collect(Collectors.toSet());
        if (allowedMediaTypes.isEmpty()) {
            return b -> true;
        }
        return b -> allowedMediaTypes.contains(b.getMappedMediaType());
    }

    private BiFunction<FormDataBodyPart, MediaType, EnhancedBodyPart.ValueExtractionMode> prepareModeSupplier() {
        return (b, m) -> {
            if (b.isFormField() && m.isCompatible(MediaType.TEXT_PLAIN_TYPE)) {
                return EnhancedBodyPart.ValueExtractionMode.EXTRACTOR;
            }
            return EnhancedBodyPart.ValueExtractionMode.MESSAGE_BODY_WORKER;
        };
    }

    private static class Mapping {
        MediaType from;
        MediaType to;

        public Mapping(MediaType from, MediaType to) {
            this.from = from;
            this.to = to;
        }
    }
}

