/*
 * Decompiled with CFR 0.152.
 */
package com.archytasit.jersey.multipart.internal.valueproviders;

import com.archytasit.jersey.multipart.exception.FormDataParamException;
import com.archytasit.jersey.multipart.internal.valueproviders.EnhancedBodyPart;
import com.archytasit.jersey.multipart.internal.valueproviders.SingleValueProvider;
import com.archytasit.jersey.multipart.utils.ClassUtils;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.model.Parameter;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractor;

public class CollectionValueProvider
extends SingleValueProvider {
    private Collector streamCollector;
    private Class<?> genericTypeArgument;

    public CollectionValueProvider(Parameter parameter, MultivaluedParameterExtractor<?> extractor) {
        super(parameter, extractor);
        this.streamCollector = ClassUtils.getStreamCollector(parameter.getRawType());
        this.genericTypeArgument = (Class)ReflectionHelper.getGenericTypeArgumentClasses((Type)parameter.getType()).get(0);
    }

    @Override
    protected Object applyToEnhancedBodyParts(ContainerRequest request, List<EnhancedBodyPart> enhancedBodyParts) {
        Set modes = enhancedBodyParts.stream().map(EnhancedBodyPart::getMode).collect(Collectors.toSet());
        if (modes.isEmpty()) {
            return null;
        }
        if (modes.size() == 1) {
            MessageBodyWorkers mbw = request.getWorkers();
            EnhancedBodyPart.ValueExtractionMode mode = (EnhancedBodyPart.ValueExtractionMode)((Object)modes.iterator().next());
            if (this.extractor == null || EnhancedBodyPart.ValueExtractionMode.MESSAGE_BODY_WORKER.equals((Object)mode)) {
                return enhancedBodyParts.stream().map(b -> this.applyMessageBodyWorker((EnhancedBodyPart)b, this.genericTypeArgument, this.genericTypeArgument, b.getMappedMediaType(), mbw)).collect(this.streamCollector);
            }
            if (this.extractor != null) {
                return this.applyExtractor(enhancedBodyParts.stream(), mbw);
            }
            return enhancedBodyParts.stream().map(b -> null).collect(this.streamCollector);
        }
        throw new FormDataParamException(new IllegalArgumentException("Mix of attachements and form fields could not be extracted"), this.getParameterName(), this.parameter.getDefaultValue());
    }
}

