/*
 * Decompiled with CFR 0.152.
 */
package com.archytasit.jersey.multipart.internal.valueproviders;

import com.archytasit.jersey.multipart.exception.FormDataParamException;
import com.archytasit.jersey.multipart.internal.valueproviders.AbstractEnhancedBodyPartsValueProvider;
import com.archytasit.jersey.multipart.internal.valueproviders.EnhancedBodyPart;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.SortedSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import org.glassfish.jersey.internal.util.collection.NullableMultivaluedHashMap;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.model.Parameter;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractor;

public class SingleValueProvider
extends AbstractEnhancedBodyPartsValueProvider<Object> {
    protected MultivaluedParameterExtractor<?> extractor;

    public SingleValueProvider(Parameter parameter, MultivaluedParameterExtractor<?> extractor) {
        super(parameter);
        this.extractor = extractor;
    }

    @Override
    protected Object applyToEnhancedBodyParts(ContainerRequest request, List<EnhancedBodyPart> enhancedBodyParts) {
        if (enhancedBodyParts.isEmpty()) {
            return null;
        }
        EnhancedBodyPart bp = enhancedBodyParts.get(0);
        if (this.extractor == null || EnhancedBodyPart.ValueExtractionMode.MESSAGE_BODY_WORKER.equals((Object)bp.getMode())) {
            return this.applyMessageBodyWorker(bp, request.getWorkers());
        }
        if (this.extractor != null) {
            return this.applyExtractor(Stream.of(bp), request.getWorkers());
        }
        return null;
    }

    protected Object applyExtractor(Stream<EnhancedBodyPart> bp, MessageBodyWorkers workers) {
        Predicate<String> filterNullOrNot = s -> true;
        if (SortedSet.class.isAssignableFrom(this.parameter.getRawType())) {
            filterNullOrNot = s -> s != null && !s.isEmpty();
        }
        NullableMultivaluedHashMap paramValuesMap = new NullableMultivaluedHashMap();
        paramValuesMap.addAll((Object)this.getParameterName(), bp.map(b -> this.asString((EnhancedBodyPart)b, workers)).filter(filterNullOrNot).collect(Collectors.toList()));
        return this.extractor.extract((MultivaluedMap)paramValuesMap);
    }

    private String asString(EnhancedBodyPart iBodyPart, MessageBodyWorkers workers) {
        return this.applyMessageBodyWorker(iBodyPart, (Class)String.class, (Type)((Object)String.class), MediaType.TEXT_PLAIN_TYPE, workers);
    }

    protected Object applyMessageBodyWorker(EnhancedBodyPart bodyPart, MessageBodyWorkers workers) {
        return this.applyMessageBodyWorker(bodyPart, this.parameter.getRawType(), this.parameter.getType(), bodyPart.getMappedMediaType(), workers);
    }

    protected <T> T applyMessageBodyWorker(EnhancedBodyPart bodyPart, Class<T> rawType, Type type, MediaType customMediaType, MessageBodyWorkers workers) {
        Object result = null;
        try {
            MessageBodyReader bodyReader;
            result = bodyPart.getBodyPart().getEntity(rawType);
            if (result == null && (bodyReader = workers.getMessageBodyReader(rawType, type, this.parameter.getAnnotations(), customMediaType)) != null) {
                result = bodyReader.readFrom(rawType, type, this.parameter.getAnnotations(), customMediaType, bodyPart.getBodyPart().getHeaders(), bodyPart.getBodyPart().getInputStream());
            }
        }
        catch (IOException e) {
            throw new FormDataParamException(e, this.getParameterName(), this.parameter.getDefaultValue());
        }
        return (T)result;
    }
}

