/*
 * Decompiled with CFR 0.152.
 */
package com.archytasit.jersey.multipart.parsers;

import com.archytasit.jersey.multipart.parsers.StreamingPart;
import java.util.Iterator;
import javax.ws.rs.InternalServerErrorException;

public class StreamingPartIterator
implements Iterator<StreamingPart> {
    private ThrowingSupplier<Boolean> hasNextSupplier;
    private ThrowingSupplier<StreamingPart> nextValueSupplier;

    public StreamingPartIterator(ThrowingSupplier<Boolean> hasNextSupplier, ThrowingSupplier<StreamingPart> nextValueSupplier) {
        if (hasNextSupplier == null || nextValueSupplier == null) {
            throw new IllegalArgumentException();
        }
        this.hasNextSupplier = hasNextSupplier;
        this.nextValueSupplier = nextValueSupplier;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.hasNextSupplier.get();
        }
        catch (Exception e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    @Override
    public StreamingPart next() {
        try {
            return this.nextValueSupplier.get();
        }
        catch (Exception e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    @FunctionalInterface
    public static interface ThrowingSupplier<T> {
        public T get() throws Exception;
    }
}

