/*
 * Decompiled with CFR 0.152.
 */
package com.archytasit.jersey.multipart.parsers.apache;

import com.archytasit.jersey.multipart.ContentDisposition;
import com.archytasit.jersey.multipart.parsers.IRequestParser;
import com.archytasit.jersey.multipart.parsers.StreamingPart;
import com.archytasit.jersey.multipart.parsers.StreamingPartIterator;
import com.archytasit.jersey.multipart.parsers.apache.RequestContextJerseyWrapper;
import com.archytasit.jersey.multipart.utils.HeadersUtils;
import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class ApachePartParser
implements IRequestParser {
    @Override
    public StreamingPartIterator getPartIterator(MediaType mediaType, MultivaluedMap headers, InputStream stream) {
        RequestContextJerseyWrapper requestContext = new RequestContextJerseyWrapper(mediaType, (MultivaluedMap<String, String>)headers, stream);
        try {
            FileItemIterator iter = new ServletFileUpload().getItemIterator((RequestContext)requestContext);
            return new StreamingPartIterator(() -> ((FileItemIterator)iter).hasNext(), () -> this.wrap(iter.next()));
        }
        catch (IOException | FileUploadException e) {
            throw new InternalServerErrorException(e);
        }
    }

    private StreamingPart wrap(FileItemStream item) throws IOException {
        MultivaluedMap<String, String> headers = HeadersUtils.toMultiValuedMap(item.getHeaders());
        ContentDisposition contentDisposition = ContentDisposition.fromHeaderValues(item.getName(), headers);
        return new StreamingPart(item.getFieldName(), HeadersUtils.getMediaType(item.getContentType()), contentDisposition, headers, item.isFormField(), item.getName(), item.openStream());
    }
}

