/*
 * Decompiled with CFR 0.152.
 */
package com.archytasit.jersey.multipart.parsers.apache;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.fileupload.RequestContext;

public class RequestContextJerseyWrapper
implements RequestContext {
    private String charset = StandardCharsets.UTF_8.name();
    private String contentType;
    private int contentLength = -1;
    private InputStream inputStream;

    public RequestContextJerseyWrapper(MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream inputStream) {
        this.charset = (String)httpHeaders.getFirst((Object)"Content-Encoding");
        this.contentType = (String)httpHeaders.getFirst((Object)"Content-Type");
        String contentLengthStr = (String)httpHeaders.getFirst((Object)"Content-Length");
        if (contentLengthStr != null && contentLengthStr.matches("[0-9]+")) {
            this.contentLength = Integer.parseInt(contentLengthStr);
        }
        if (mediaType != null) {
            String string = this.charset = mediaType != null ? (String)mediaType.getParameters().get("charset") : null;
            if (this.charset == null) {
                // empty if block
            }
        }
        this.inputStream = inputStream;
    }

    public String getCharacterEncoding() {
        return this.charset;
    }

    public String getContentType() {
        return this.contentType;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public InputStream getInputStream() throws IOException {
        return this.inputStream;
    }
}

