/*
 * Decompiled with CFR 0.152.
 */
package com.archytasit.jersey.multipart.utils;

import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.InternalServerErrorException;

public class ClassUtils {
    private static final Set<Class<?>> TYPES = Stream.of(Byte.class, Byte.TYPE, Short.class, Short.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Float.class, Float.TYPE, Double.class, Double.TYPE, Boolean.class, Boolean.TYPE, Character.class, Character.TYPE).collect(Collectors.toSet());

    public static boolean isPrimitive(Class<?> type) {
        return TYPES.contains(type);
    }

    public static Collector getStreamCollector(Class<?> collectionClass) {
        if (List.class.isAssignableFrom(collectionClass)) {
            return Collectors.toList();
        }
        if (SortedSet.class.isAssignableFrom(collectionClass)) {
            return Collectors.toCollection(TreeSet::new);
        }
        if (Set.class.isAssignableFrom(collectionClass)) {
            return Collectors.toSet();
        }
        throw new InternalServerErrorException("kind of collection not managed");
    }
}

