/*
 * Decompiled with CFR 0.152.
 */
package com.archytasit.jersey.multipart.utils;

import java.nio.charset.Charset;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.fileupload.FileItemHeaders;

public class HeadersUtils {
    public static final MediaType MULTIPART_WILDCARD_MEDIATYPE = new MediaType("multipart", "*");

    public static MediaType getMediaType(String contentType) {
        if (contentType != null && contentType.trim().length() > 0) {
            try {
                return MediaType.valueOf((String)contentType);
            }
            catch (IllegalArgumentException e) {
                Logger.getLogger(HeadersUtils.class.getName()).log(Level.WARNING, "unknown media type");
            }
        }
        return null;
    }

    public static Charset getCharset(MediaType mediaType) {
        if (mediaType != null && mediaType.getParameters().get("charset") != null) {
            return Charset.forName((String)mediaType.getParameters().get("charset"));
        }
        return null;
    }

    public static MultivaluedMap<String, String> toMultiValuedMap(FileItemHeaders headers) {
        MultivaluedHashMap result = new MultivaluedHashMap();
        if (headers != null) {
            Iterable headerNamesIterable = () -> headers.getHeaderNames();
            List headerNames = StreamSupport.stream(headerNamesIterable.spliterator(), false).filter(Objects::nonNull).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
            for (String headerName : headerNames) {
                Iterable headerValuesIterable = () -> headers.getHeaders(headerName);
                List headerValues = StreamSupport.stream(headerValuesIterable.spliterator(), false).filter(Objects::nonNull).collect(Collectors.toList());
                result.put((Object)headerName, headerValues);
            }
        }
        return result;
    }
}

