/*
 * Decompiled with CFR 0.152.
 */
package com.archytasit.jersey.multipart.utils;

import java.io.IOException;
import java.io.InputStream;

public class InputStreamCounter
extends InputStream {
    protected long counter = 0L;
    protected InputStream is;

    public InputStreamCounter(InputStream is) {
        this.is = is;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.addToCounterInt(this.is.read(b));
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.addToCounterInt(this.is.read(b, off, len));
    }

    @Override
    public long skip(long n) throws IOException {
        return this.addToCounter(this.is.skip(n));
    }

    protected long addToCounter(long num) {
        this.counter += num;
        return num;
    }

    private int addToCounterInt(int num) {
        this.addToCounter(num);
        return num;
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
        this.counter = 0L;
    }

    @Override
    public int read() throws IOException {
        int result = this.is.read();
        if (result > -1) {
            this.addToCounter(1L);
        }
        return result;
    }

    @Override
    public int available() throws IOException {
        return super.available();
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        super.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return super.markSupported();
    }

    public long getContentRead() {
        return this.counter;
    }
}

