/*
 * Decompiled with CFR 0.152.
 */
package com.archytasit.jersey.multipart.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamUtils {
    public static final int BUFFER_SIZE = 8192;

    public static void toOutStream(InputStream openStream, OutputStream outStream) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[8192];
        while ((bytesRead = openStream.read(buffer)) != -1) {
            outStream.write(buffer, 0, bytesRead);
        }
        outStream.flush();
    }

    public static void toNullStream(InputStream openStream, OutputStream outStream) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[8192];
        while ((bytesRead = openStream.read(buffer)) != -1) {
            outStream.write(buffer, 0, bytesRead);
        }
        outStream.flush();
    }

    public static File toTempFileNoClose(InputStream inStream, File tempFile) throws IOException {
        try (FileOutputStream outStream = new FileOutputStream(tempFile);){
            StreamUtils.toOutStream(inStream, outStream);
        }
        return tempFile;
    }

    public static byte[] toBytesNoClose(InputStream inStream) throws IOException {
        try (ByteArrayOutputStream outStream = new ByteArrayOutputStream();){
            StreamUtils.toOutStream(inStream, outStream);
            byte[] byArray = outStream.toByteArray();
            return byArray;
        }
    }
}

