/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.api.config.strategy;

import com.google.common.base.Preconditions;
import io.shardingjdbc.core.api.config.strategy.ShardingStrategyConfiguration;
import io.shardingjdbc.core.routing.strategy.ShardingStrategy;
import io.shardingjdbc.core.routing.strategy.inline.InlineShardingStrategy;
import java.beans.ConstructorProperties;

public final class InlineShardingStrategyConfiguration
implements ShardingStrategyConfiguration {
    private final String shardingColumn;
    private final String algorithmInlineExpression;

    @Override
    public ShardingStrategy build() {
        Preconditions.checkNotNull((Object)this.shardingColumn, (Object)"Sharding column cannot be null.");
        Preconditions.checkNotNull((Object)this.algorithmInlineExpression, (Object)"Algorithm inline expression cannot be null.");
        return new InlineShardingStrategy(this.shardingColumn, this.algorithmInlineExpression);
    }

    @ConstructorProperties(value={"shardingColumn", "algorithmInlineExpression"})
    public InlineShardingStrategyConfiguration(String shardingColumn, String algorithmInlineExpression) {
        this.shardingColumn = shardingColumn;
        this.algorithmInlineExpression = algorithmInlineExpression;
    }

    public String getShardingColumn() {
        return this.shardingColumn;
    }

    public String getAlgorithmInlineExpression() {
        return this.algorithmInlineExpression;
    }
}

