/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.executor.threadlocal;

import io.shardingjdbc.core.exception.ShardingJdbcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExecutorExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(ExecutorExceptionHandler.class);
    private static final ThreadLocal<Boolean> IS_EXCEPTION_THROWN = new ThreadLocal();

    public static void setExceptionThrown(boolean isExceptionThrown) {
        IS_EXCEPTION_THROWN.set(isExceptionThrown);
    }

    public static boolean isExceptionThrown() {
        return null == IS_EXCEPTION_THROWN.get() ? true : IS_EXCEPTION_THROWN.get();
    }

    public static void handleException(Exception exception) {
        if (ExecutorExceptionHandler.isExceptionThrown()) {
            throw new ShardingJdbcException(exception);
        }
        log.error("exception occur: ", (Throwable)exception);
    }

    private ExecutorExceptionHandler() {
    }
}

