/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.merger;

import io.shardingjdbc.core.merger.ResultSetMerger;
import io.shardingjdbc.core.merger.groupby.GroupByMemoryResultSetMerger;
import io.shardingjdbc.core.merger.groupby.GroupByStreamResultSetMerger;
import io.shardingjdbc.core.merger.iterator.IteratorStreamResultSetMerger;
import io.shardingjdbc.core.merger.limit.LimitDecoratorResultSetMerger;
import io.shardingjdbc.core.merger.orderby.OrderByStreamResultSetMerger;
import io.shardingjdbc.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingjdbc.core.util.SQLUtil;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class MergeEngine {
    private final List<ResultSet> resultSets;
    private final SelectStatement selectStatement;
    private final Map<String, Integer> columnLabelIndexMap;

    public MergeEngine(List<ResultSet> resultSets, SelectStatement selectStatement) throws SQLException {
        this.resultSets = resultSets;
        this.selectStatement = selectStatement;
        this.columnLabelIndexMap = this.getColumnLabelIndexMap(resultSets.get(0));
    }

    private Map<String, Integer> getColumnLabelIndexMap(ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        TreeMap<String, Integer> result = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            result.put(SQLUtil.getExactlyValue(resultSetMetaData.getColumnLabel(i)), i);
        }
        return result;
    }

    public ResultSetMerger merge() throws SQLException {
        this.selectStatement.setIndexForItems(this.columnLabelIndexMap);
        return this.decorate(this.build());
    }

    private ResultSetMerger build() throws SQLException {
        if (!this.selectStatement.getGroupByItems().isEmpty() || !this.selectStatement.getAggregationSelectItems().isEmpty()) {
            if (this.selectStatement.isSameGroupByAndOrderByItems()) {
                return new GroupByStreamResultSetMerger(this.columnLabelIndexMap, this.resultSets, this.selectStatement);
            }
            return new GroupByMemoryResultSetMerger(this.columnLabelIndexMap, this.resultSets, this.selectStatement);
        }
        if (!this.selectStatement.getOrderByItems().isEmpty()) {
            return new OrderByStreamResultSetMerger(this.resultSets, this.selectStatement.getOrderByItems());
        }
        return new IteratorStreamResultSetMerger(this.resultSets);
    }

    private ResultSetMerger decorate(ResultSetMerger resultSetMerger) throws SQLException {
        ResultSetMerger result = resultSetMerger;
        if (null != this.selectStatement.getLimit()) {
            result = new LimitDecoratorResultSetMerger(result, this.selectStatement.getLimit());
        }
        return result;
    }
}

