/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.parsing.parser.context;

import com.google.common.base.Optional;
import io.shardingjdbc.core.constant.OrderType;

public final class OrderItem {
    private final Optional<String> owner;
    private final Optional<String> name;
    private final OrderType type;
    private final OrderType nullOrderType;
    private int index = -1;
    private Optional<String> alias;

    public OrderItem(String name, OrderType type, OrderType nullOrderType, Optional<String> alias) {
        this.owner = Optional.absent();
        this.name = Optional.of((Object)name);
        this.type = type;
        this.nullOrderType = nullOrderType;
        this.alias = alias;
    }

    public OrderItem(String owner, String name, OrderType type, OrderType nullOrderType, Optional<String> alias) {
        this.owner = Optional.of((Object)owner);
        this.name = Optional.of((Object)name);
        this.type = type;
        this.nullOrderType = nullOrderType;
        this.alias = alias;
    }

    public OrderItem(int index, OrderType type, OrderType nullOrderType) {
        this.owner = Optional.absent();
        this.name = Optional.absent();
        this.index = index;
        this.type = type;
        this.nullOrderType = nullOrderType;
        this.alias = Optional.absent();
    }

    public String getColumnLabel() {
        return this.alias.isPresent() ? (String)this.alias.get() : (String)this.name.orNull();
    }

    public Optional<String> getQualifiedName() {
        if (!this.name.isPresent()) {
            return Optional.absent();
        }
        return this.owner.isPresent() ? Optional.of((Object)((String)this.owner.get() + "." + (String)this.name.get())) : this.name;
    }

    public Optional<String> getOwner() {
        return this.owner;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public OrderType getType() {
        return this.type;
    }

    public OrderType getNullOrderType() {
        return this.nullOrderType;
    }

    public int getIndex() {
        return this.index;
    }

    public Optional<String> getAlias() {
        return this.alias;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setAlias(Optional<String> alias) {
        this.alias = alias;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrderItem)) {
            return false;
        }
        OrderItem other = (OrderItem)o;
        Optional<String> this$owner = this.getOwner();
        Optional<String> other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        Optional<String> this$name = this.getName();
        Optional<String> other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        OrderType this$type = this.getType();
        OrderType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        OrderType this$nullOrderType = this.getNullOrderType();
        OrderType other$nullOrderType = other.getNullOrderType();
        if (this$nullOrderType == null ? other$nullOrderType != null : !((Object)((Object)this$nullOrderType)).equals((Object)other$nullOrderType)) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        Optional<String> this$alias = this.getAlias();
        Optional<String> other$alias = other.getAlias();
        return !(this$alias == null ? other$alias != null : !this$alias.equals(other$alias));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<String> $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 0 : $owner.hashCode());
        Optional<String> $name = this.getName();
        result = result * 59 + ($name == null ? 0 : $name.hashCode());
        OrderType $type = this.getType();
        result = result * 59 + ($type == null ? 0 : ((Object)((Object)$type)).hashCode());
        OrderType $nullOrderType = this.getNullOrderType();
        result = result * 59 + ($nullOrderType == null ? 0 : ((Object)((Object)$nullOrderType)).hashCode());
        result = result * 59 + this.getIndex();
        Optional<String> $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 0 : $alias.hashCode());
        return result;
    }

    public String toString() {
        return "OrderItem(owner=" + this.getOwner() + ", name=" + this.getName() + ", type=" + (Object)((Object)this.getType()) + ", nullOrderType=" + (Object)((Object)this.getNullOrderType()) + ", index=" + this.getIndex() + ", alias=" + this.getAlias() + ")";
    }
}

