/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.rule;

import com.google.common.base.Preconditions;
import io.shardingjdbc.core.api.algorithm.masterslave.MasterSlaveLoadBalanceAlgorithm;
import io.shardingjdbc.core.api.algorithm.masterslave.MasterSlaveLoadBalanceAlgorithmType;
import java.util.Map;
import javax.sql.DataSource;

public final class MasterSlaveRule {
    private final String name;
    private final String masterDataSourceName;
    private final DataSource masterDataSource;
    private final Map<String, DataSource> slaveDataSourceMap;
    private final MasterSlaveLoadBalanceAlgorithm strategy;

    public MasterSlaveRule(String name, String masterDataSourceName, DataSource masterDataSource, Map<String, DataSource> slaveDataSourceMap) {
        this(name, masterDataSourceName, masterDataSource, slaveDataSourceMap, null);
    }

    public MasterSlaveRule(String name, String masterDataSourceName, DataSource masterDataSource, Map<String, DataSource> slaveDataSourceMap, MasterSlaveLoadBalanceAlgorithm strategy) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)masterDataSourceName);
        Preconditions.checkNotNull((Object)masterDataSource);
        Preconditions.checkNotNull(slaveDataSourceMap);
        Preconditions.checkState((!slaveDataSourceMap.isEmpty() ? 1 : 0) != 0);
        this.name = name;
        this.masterDataSourceName = masterDataSourceName;
        this.masterDataSource = masterDataSource;
        this.slaveDataSourceMap = slaveDataSourceMap;
        this.strategy = null == strategy ? MasterSlaveLoadBalanceAlgorithmType.getDefaultAlgorithmType().getAlgorithm() : strategy;
    }

    public String getName() {
        return this.name;
    }

    public String getMasterDataSourceName() {
        return this.masterDataSourceName;
    }

    public DataSource getMasterDataSource() {
        return this.masterDataSource;
    }

    public Map<String, DataSource> getSlaveDataSourceMap() {
        return this.slaveDataSourceMap;
    }

    public MasterSlaveLoadBalanceAlgorithm getStrategy() {
        return this.strategy;
    }
}

