/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.elasticsearch.http;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import zipkin.internal.Util;
import zipkin.storage.elasticsearch.http.AutoValue_IndexNameFormatter;

abstract class IndexNameFormatter {
    private static final String DAILY_INDEX_FORMAT = "yyyy-MM-dd";
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");

    IndexNameFormatter() {
    }

    static Builder builder() {
        return new AutoValue_IndexNameFormatter.Builder();
    }

    abstract Builder toBuilder();

    abstract String index();

    abstract char dateSeparator();

    abstract ThreadLocal<SimpleDateFormat> dateFormat();

    List<String> indexNamePatternsForRange(long beginMillis, long endMillis) {
        GregorianCalendar end;
        GregorianCalendar current = IndexNameFormatter.midnightUTC(beginMillis);
        if (current.equals(end = IndexNameFormatter.midnightUTC(endMillis))) {
            return Collections.singletonList(this.indexNameForTimestamp(current.getTimeInMillis()));
        }
        ArrayList<String> indices = new ArrayList<String>();
        while (current.compareTo(end) <= 0) {
            if (current.get(2) == 0 && current.get(5) == 1) {
                current.set(6, current.getActualMaximum(6));
                if (current.compareTo(end) <= 0) {
                    indices.add(String.format("%s-%s%c*", this.index(), current.get(1), Character.valueOf(this.dateSeparator())));
                    current.add(5, 1);
                    continue;
                }
                current.set(6, 1);
            } else if (current.get(5) == 1) {
                current.set(5, current.getActualMaximum(5));
                if (current.compareTo(end) <= 0) {
                    indices.add(String.format("%s-%s%c%02d%c*", this.index(), current.get(1), Character.valueOf(this.dateSeparator()), current.get(2) + 1, Character.valueOf(this.dateSeparator())));
                    current.add(5, 1);
                    continue;
                }
                current.set(5, 1);
            }
            indices.add(this.indexNameForTimestamp(current.getTimeInMillis()));
            current.add(5, 1);
        }
        return indices;
    }

    static GregorianCalendar midnightUTC(long epochMillis) {
        GregorianCalendar result = new GregorianCalendar(UTC);
        result.setTimeInMillis(Util.midnightUTC((long)epochMillis));
        return result;
    }

    String indexNameForTimestamp(long timestampMillis) {
        return this.index() + "-" + this.dateFormat().get().format(new Date(timestampMillis));
    }

    long parseDate(String timestamp) {
        try {
            return this.dateFormat().get().parse(timestamp).getTime();
        }
        catch (ParseException e) {
            throw new AssertionError((Object)e);
        }
    }

    String allIndices() {
        return this.index() + "-*";
    }

    static abstract class Builder {
        Builder() {
        }

        abstract Builder index(String var1);

        abstract Builder dateSeparator(char var1);

        abstract Builder dateFormat(ThreadLocal<SimpleDateFormat> var1);

        abstract char dateSeparator();

        final IndexNameFormatter build() {
            return this.dateFormat(new ThreadLocal<SimpleDateFormat>(){

                @Override
                protected SimpleDateFormat initialValue() {
                    SimpleDateFormat result = new SimpleDateFormat(IndexNameFormatter.DAILY_INDEX_FORMAT.replace('-', Builder.this.dateSeparator()));
                    result.setTimeZone(TimeZone.getTimeZone("UTC"));
                    return result;
                }
            }).autoBuild();
        }

        abstract IndexNameFormatter autoBuild();
    }
}

