/*
 * Decompiled with CFR 0.152.
 */
package me.hao0.diablo.client;

import com.fasterxml.jackson.databind.JavaType;
import com.github.kevinsawicki.http.HttpRequest;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.hao0.common.http.Http;
import me.hao0.common.http.HttpMethod;
import me.hao0.common.util.Strings;
import me.hao0.diablo.client.AbstractDiabloClient;
import me.hao0.diablo.client.exception.AuthFailException;
import me.hao0.diablo.client.exception.RouteServerException;
import me.hao0.diablo.client.exception.Server503Exception;
import me.hao0.diablo.common.model.ConfigItem;
import me.hao0.diablo.common.model.JsonResponse;
import me.hao0.diablo.common.model.ServerRouteResp;
import me.hao0.diablo.common.util.Joiners;
import me.hao0.diablo.common.util.JsonUtil;
import me.hao0.diablo.common.util.SysUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DiabloAgent {
    private static final Logger log = LoggerFactory.getLogger(DiabloAgent.class);
    private static final String CLIENT_VERSION = "1.2.1";
    private AbstractDiabloClient client;
    private volatile String currentServer;
    private final Map<String, String> headers = Maps.newHashMap();

    DiabloAgent(AbstractDiabloClient client) {
        this.client = client;
    }

    void start() {
        this.routeServer();
    }

    List<ConfigItem> fetchConfigs(Set<String> names) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)1);
        params.put("names", Joiners.COMMA.join(names));
        return (List)this.doGet("/configs_fetches", this.headers, params, JsonUtil.LIST_CONFIG_ITEM_TYPE);
    }

    public List<ConfigItem> fetchAllConfig() {
        return (List)this.doGet("/configs_fetch_all", this.headers, null, JsonUtil.LIST_CONFIG_ITEM_TYPE);
    }

    public Set<String> pullingUpdatedConfigs(Map<String, String> configItemMaps, int readTimeout) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)1);
        params.put("configs", JsonUtil.INSTANCE.toJson(configItemMaps));
        return (Set)this.doPost("/configs_pulling", this.headers, params, readTimeout, Set.class);
    }

    void routeServer() {
        Object[] serverList;
        HashMap params = Maps.newHashMap();
        params.put("appName", this.client.getAppName());
        params.put("clientPid", SysUtil.pid());
        for (String string : serverList = this.client.getServers().split(",")) {
            try {
                ServerRouteResp resp = (ServerRouteResp)this.doGet(string, "/servers_route", null, params, ServerRouteResp.class);
                if (resp == null) {
                    log.warn("server({}) route is null", (Object)string);
                    continue;
                }
                String routedServer = resp.getServer();
                String clientId = resp.getClientId();
                params.put("clientId", clientId);
                params.put("appKey", this.client.getAppKey());
                Boolean registerResp = (Boolean)this.doGet(routedServer, "/register", null, params, Boolean.class);
                if (registerResp == Boolean.FALSE) {
                    log.warn("failed to register server({})", (Object)routedServer);
                    continue;
                }
                this.currentServer = routedServer;
                this.headers.put("Client-ID", clientId);
                this.headers.put("appKey", this.client.getAppKey());
                this.headers.put("Client-Ver", CLIENT_VERSION);
                this.headers.put("Pulling-Timeout", String.valueOf(this.client.getPullingTimeout()));
                log.info("route successfully, current server is {}", (Object)this.currentServer);
                return;
            }
            catch (HttpRequest.HttpRequestException e) {
                log.warn("server({}) is unavailable, trying next server", (Object)string);
            }
        }
        throw new Server503Exception("all servers are unavailable: " + Arrays.toString(serverList));
    }

    protected void unRegister() {
        this.doGet("/un_register", this.headers, null, Boolean.class);
    }

    <T> T doGet(String uri, Map<String, String> headers, Map<String, Object> params, Object respType) {
        while (true) {
            try {
                return this.doGet(this.currentServer, uri, headers, params, respType);
            }
            catch (AuthFailException e) {
                throw new IllegalArgumentException("appKey isn't right, please check");
            }
            catch (HttpRequest.HttpRequestException | RouteServerException e) {
                String oldServer = this.currentServer;
                log.warn("current server({}) is unavailable, trying to route a new server", (Object)oldServer);
                this.routeServer();
                log.warn("old server({}) is unavailable, routed a new server({})", (Object)oldServer, (Object)this.currentServer);
                continue;
            }
            break;
        }
    }

    private <T> T doGet(String server, String uri, Map<String, String> headers, Map<String, Object> params, Object respType) {
        return this.doRequest(server, uri, HttpMethod.GET, headers, params, 0, respType);
    }

    <T> T doPost(String uri, Map<String, String> headers, Map<String, Object> params, int readTimeout, Object respType) {
        while (true) {
            try {
                return this.doPost(this.currentServer, uri, headers, params, readTimeout, respType);
            }
            catch (AuthFailException e) {
                throw new IllegalArgumentException("appKey isn't right, please check");
            }
            catch (HttpRequest.HttpRequestException | RouteServerException e) {
                String oldServer = this.currentServer;
                log.warn("current server({}) is maybe unavailable, trying to route a new server", (Object)oldServer);
                this.routeServer();
                log.warn("old server({}) is unavailable, routed a new server({})", (Object)oldServer, (Object)this.currentServer);
                continue;
            }
            break;
        }
    }

    private <T> T doPost(String server, String uri, Map<String, String> headers, Map<String, Object> params, int readTimeout, Object respType) {
        return this.doRequest(server, uri, HttpMethod.POST, headers, params, readTimeout, respType);
    }

    private <T> T doRequest(String server, String uri, HttpMethod method, Map<String, String> headers, Map<String, Object> params, int readTimeout, Object respType) {
        String resp;
        String reqUri = "http://" + server + "/apis" + uri;
        Http http = method == HttpMethod.GET ? Http.get((String)reqUri) : Http.post((String)reqUri);
        if (readTimeout > 0) {
            http.readTimeout(Integer.valueOf(readTimeout));
        }
        if (headers != null) {
            http.headers(headers);
        }
        if (Strings.isNullOrEmpty((String)(resp = http.params(params).request())).booleanValue()) {
            return null;
        }
        this.checkRespErr(resp);
        return (T)(respType instanceof JavaType ? JsonUtil.INSTANCE.fromJson(resp, (JavaType)respType) : JsonUtil.INSTANCE.fromJson(resp, (Class)respType));
    }

    private void checkRespErr(String resp) {
        if (Objects.equal((Object)JsonResponse.SERVER_ERR.getStatus().toString(), (Object)resp)) {
            throw new RouteServerException();
        }
        if (Objects.equal((Object)JsonResponse.NEED_LOGIN.getStatus().toString(), (Object)resp)) {
            throw new RouteServerException();
        }
        if (Objects.equal((Object)JsonResponse.AUTH_FAIL.getStatus().toString(), (Object)resp)) {
            throw new AuthFailException();
        }
    }
}

