/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Locale;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Site;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.report.projectinfo.AbstractProjectInfoRenderer;
import org.apache.maven.report.projectinfo.AbstractProjectInfoReport;
import org.codehaus.plexus.i18n.I18N;

@Mojo(name="modules")
public class ModulesReport
extends AbstractProjectInfoReport {
    @Override
    public boolean canGenerateReport() {
        boolean result = super.canGenerateReport();
        if (result && this.skipEmptyReport) {
            result = !this.isEmpty(this.getProject().getModel().getModules());
        }
        return result;
    }

    public void executeReport(Locale locale) {
        new ModulesRenderer(this.getSink(), this.getProject(), this.getReactorProjects(), this.projectBuilder, this.localRepository, this.getI18N(locale), locale, this.getLog(), this.siteTool).render();
    }

    public String getOutputName() {
        return "modules";
    }

    @Override
    protected String getI18Nsection() {
        return "modules";
    }

    static class ModulesRenderer
    extends AbstractProjectInfoRenderer {
        protected final Log log;
        protected MavenProject project;
        protected List<MavenProject> reactorProjects;
        protected ProjectBuilder projectBuilder;
        protected ArtifactRepository localRepository;
        protected SiteTool siteTool;

        ModulesRenderer(Sink sink, MavenProject project, List<MavenProject> reactorProjects, ProjectBuilder projectBuilder, ArtifactRepository localRepository, I18N i18n, Locale locale, Log log, SiteTool siteTool) {
            super(sink, i18n, locale);
            this.project = project;
            this.reactorProjects = reactorProjects;
            this.projectBuilder = projectBuilder;
            this.localRepository = localRepository;
            this.siteTool = siteTool;
            this.log = log;
        }

        @Override
        protected String getI18Nsection() {
            return "modules";
        }

        protected void renderBody() {
            List modules = this.project.getModel().getModules();
            if (modules == null || modules.isEmpty()) {
                this.startSection(this.getTitle());
                this.paragraph(this.getI18nString("nolist"));
                this.endSection();
                return;
            }
            this.startSection(this.getTitle());
            this.paragraph(this.getI18nString("intro"));
            this.startTable();
            String name = this.getI18nString("header.name");
            String description = this.getI18nString("header.description");
            this.tableHeader(new String[]{name, description});
            String baseUrl = ModulesRenderer.getDistMgmntSiteUrl(this.project);
            DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest();
            buildingRequest.setLocalRepository(this.localRepository);
            buildingRequest.setProcessPlugins(false);
            for (String module : modules) {
                MavenProject moduleProject = this.getModuleFromReactor(this.project, this.reactorProjects, module);
                if (moduleProject == null) {
                    this.log.warn((CharSequence)("Module " + module + " not found in reactor: loading locally"));
                    File f = new File(this.project.getBasedir(), module + "/pom.xml");
                    if (f.exists()) {
                        try {
                            moduleProject = this.projectBuilder.build(f, (ProjectBuildingRequest)buildingRequest).getProject();
                        }
                        catch (ProjectBuildingException e) {
                            throw new IllegalStateException("Unable to read local module POM", e);
                        }
                    } else {
                        moduleProject = new MavenProject();
                        moduleProject.setName(module);
                        moduleProject.setDistributionManagement(new DistributionManagement());
                        moduleProject.getDistributionManagement().setSite(new Site());
                        moduleProject.getDistributionManagement().getSite().setUrl(module);
                    }
                }
                String moduleName = moduleProject.getName() == null ? moduleProject.getArtifactId() : moduleProject.getName();
                String moduleHref = this.getRelativeLink(baseUrl, ModulesRenderer.getDistMgmntSiteUrl(moduleProject), moduleProject.getArtifactId());
                this.tableRow(new String[]{this.linkedName(moduleName, moduleHref), moduleProject.getDescription()});
            }
            this.endTable();
            this.endSection();
        }

        private MavenProject getModuleFromReactor(MavenProject project, List<MavenProject> reactorProjects, String module) {
            if (reactorProjects == null) {
                return null;
            }
            try {
                File moduleBasedir = new File(project.getBasedir(), module).getCanonicalFile();
                for (MavenProject reactorProject : reactorProjects) {
                    if (!moduleBasedir.equals(reactorProject.getBasedir())) continue;
                    return reactorProject;
                }
            }
            catch (IOException e) {
                this.log.error((CharSequence)("Error while populating modules menu: " + e.getMessage()), (Throwable)e);
            }
            return null;
        }

        private static String getDistMgmntSiteUrl(MavenProject project) {
            return ModulesRenderer.getDistMgmntSiteUrl(project.getDistributionManagement());
        }

        private static String getDistMgmntSiteUrl(DistributionManagement distMgmnt) {
            if (distMgmnt != null && distMgmnt.getSite() != null && distMgmnt.getSite().getUrl() != null) {
                return ModulesRenderer.urlEncode(distMgmnt.getSite().getUrl());
            }
            return null;
        }

        private static String urlEncode(String url) {
            if (url == null) {
                return null;
            }
            try {
                return new File(url).toURI().toURL().toExternalForm();
            }
            catch (MalformedURLException ex) {
                return url;
            }
        }

        private String getRelativeLink(String baseUrl, String href, String defaultHref) {
            String selectedHref = href;
            if (selectedHref == null) {
                selectedHref = defaultHref;
            }
            if (baseUrl != null) {
                selectedHref = this.siteTool.getRelativePath(selectedHref, baseUrl);
            }
            selectedHref = selectedHref.endsWith("/") ? selectedHref.concat("index.html") : selectedHref.concat("/index.html");
            return selectedHref;
        }

        private String linkedName(String name, String link) {
            return "{" + name + ", ./" + link + "}";
        }
    }
}

