/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import org.bytedeco.javacpp.indexer.FloatIndexer;

public class FloatArrayIndexer
extends FloatIndexer {
    protected float[] array;

    public FloatArrayIndexer(float[] array) {
        this(array, new long[]{array.length}, ONE_STRIDE);
    }

    public FloatArrayIndexer(float[] array, long ... sizes) {
        this(array, sizes, FloatArrayIndexer.strides(sizes));
    }

    public FloatArrayIndexer(float[] array, long[] sizes, long[] strides) {
        super(sizes, strides);
        this.array = array;
    }

    public float[] array() {
        return this.array;
    }

    @Override
    public float get(long i) {
        return this.array[(int)i];
    }

    @Override
    public FloatIndexer get(long i, float[] f, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            f[offset + n] = this.array[(int)i * (int)this.strides[0] + n];
        }
        return this;
    }

    @Override
    public float get(long i, long j) {
        return this.array[(int)i * (int)this.strides[0] + (int)j];
    }

    @Override
    public FloatIndexer get(long i, long j, float[] f, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            f[offset + n] = this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + n];
        }
        return this;
    }

    @Override
    public float get(long i, long j, long k) {
        return this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + (int)k];
    }

    @Override
    public float get(long ... indices) {
        return this.array[(int)this.index(indices)];
    }

    @Override
    public FloatIndexer get(long[] indices, float[] f, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            f[offset + n] = this.array[(int)this.index(indices) + n];
        }
        return this;
    }

    @Override
    public FloatIndexer put(long i, float f) {
        this.array[(int)i] = f;
        return this;
    }

    @Override
    public FloatIndexer put(long i, float[] f, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[(int)i * (int)this.strides[0] + n] = f[offset + n];
        }
        return this;
    }

    @Override
    public FloatIndexer put(long i, long j, float f) {
        this.array[(int)i * (int)this.strides[0] + (int)j] = f;
        return this;
    }

    @Override
    public FloatIndexer put(long i, long j, float[] f, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + n] = f[offset + n];
        }
        return this;
    }

    @Override
    public FloatIndexer put(long i, long j, long k, float f) {
        this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + (int)k] = f;
        return this;
    }

    @Override
    public FloatIndexer put(long[] indices, float f) {
        this.array[(int)this.index((long[])indices)] = f;
        return this;
    }

    @Override
    public FloatIndexer put(long[] indices, float[] f, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[(int)this.index((long[])indices) + n] = f[offset + n];
        }
        return this;
    }

    @Override
    public void release() {
        this.array = null;
    }
}

