package org.cache2k.core.api;

/*-
 * #%L
 * cache2k core implementation
 * %%
 * Copyright (C) 2000 - 2022 headissue GmbH, Munich
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

/**
 * Describes a single problem of a cache, for example a bad hash quality.
 * A collection of these element comprise the complete health information.
 *
 * @author Jens Wilke
 */
public interface HealthInfoElement {

  String WARNING = "WARNING";
  String FAILURE = "FAILURE";

  /**
   * Compact unique id of the message.
   */
  String getId();

  /**
   * Text message describing the problem.
   */
  String getMessage();

  /**
   * Either {@link #WARNING} or {@link #FAILURE}
   */
  String getLevel();

  /**
   * Cache reporting the trouble.
   */
  InternalCache getCache();

}
