/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.oracle;

import java.util.List;
import org.geolatte.geom.LLAPositionVisitor;
import org.geolatte.geom.LLAPositionVisitors;
import org.geolatte.geom.Position;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.PositionSequenceBuilder;
import org.geolatte.geom.PositionSequenceBuilders;
import org.geolatte.geom.codec.db.oracle.Element;
import org.geolatte.geom.codec.db.oracle.ElementType;
import org.geolatte.geom.codec.db.oracle.SDOGType;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

class CompoundElement
extends Element {
    private final List<Element> subelements;

    public CompoundElement(ElementType elementType, List<Element> subelements) {
        super(elementType);
        this.subelements = subelements;
    }

    @Override
    boolean isCompound() {
        return true;
    }

    List<Element> getSubelements() {
        return this.subelements;
    }

    @Override
    <P extends Position> PositionSequence<P> linearizedPositions(SDOGType gtype, CoordinateReferenceSystem<P> crs) {
        PositionSequenceBuilder<P> builder = PositionSequenceBuilders.variableSized(crs.getPositionClass());
        LLAPositionVisitor visitor = LLAPositionVisitors.mkCombiningVisitor(builder);
        for (Element el : this.getSubelements()) {
            el.linearizedPositions(gtype, crs).accept(visitor);
        }
        return builder.toPositionSequence();
    }
}

