/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.oracle;

import org.geolatte.geom.Envelope;
import org.geolatte.geom.Position;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.PositionSequenceBuilder;
import org.geolatte.geom.PositionSequenceBuilders;
import org.geolatte.geom.codec.db.oracle.Element;
import org.geolatte.geom.codec.db.oracle.ElementType;
import org.geolatte.geom.codec.db.oracle.SDOGType;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

class SimpleElement
extends Element {
    private final Double[] ordinates;

    public SimpleElement(ElementType elementType, Double[] ordinates) {
        super(elementType);
        this.ordinates = ordinates;
    }

    boolean hasArcSegments() {
        return this.getElementType().hasArcSegment();
    }

    @Override
    boolean isCompound() {
        return false;
    }

    @Override
    <P extends Position> PositionSequence<P> linearizedPositions(SDOGType gtype, CoordinateReferenceSystem<P> crs) {
        PositionSequence<P> positions = this.toPositions(this.ordinates, gtype, crs);
        if (this.isCircle() || this.hasArcSegments()) {
            return this.linearizer.linearize(positions, this.isCircle());
        }
        if (this.isRect()) {
            P lowerLeft = positions.first();
            P upperRight = positions.last();
            Envelope<P> env = new Envelope<P>(lowerLeft, upperRight, crs);
            if (this.isExteriorRing()) {
                return PositionSequenceBuilders.fixedSized(5, crs.getPositionClass()).add(env.lowerLeft()).add(env.lowerRight()).add(env.upperRight()).add(env.upperLeft()).add(env.lowerLeft()).toPositionSequence();
            }
            return PositionSequenceBuilders.fixedSized(5, crs.getPositionClass()).add(env.lowerLeft()).add(env.upperLeft()).add(env.upperRight()).add(env.lowerRight()).add(env.lowerLeft()).toPositionSequence();
        }
        return positions;
    }

    protected <P extends Position> PositionSequence<P> toPositions(Double[] oordinates, SDOGType gtype, CoordinateReferenceSystem<P> crs) {
        int dim = gtype.getDimension();
        int numPos = oordinates.length / dim;
        PositionSequenceBuilder<double[]> sequenceBuilder = PositionSequenceBuilders.fixedSized(numPos, crs.getPositionClass());
        int zDim = gtype.getZDimension() - 1;
        int lrsDim = gtype.getLRSDimension() - 1;
        double[] buffer = new double[dim];
        for (int posIdx = 0; posIdx < numPos; ++posIdx) {
            int componentIdx = 0;
            buffer[componentIdx] = oordinates[posIdx * dim + componentIdx];
            buffer[++componentIdx] = oordinates[posIdx * dim + componentIdx];
            if (zDim > 0) {
                Double zOrdinate = oordinates[posIdx * dim + zDim];
                double d = buffer[++componentIdx] = zOrdinate == null ? Double.NaN : zOrdinate;
            }
            if (lrsDim > 0) {
                buffer[++componentIdx] = oordinates[posIdx * dim + lrsDim];
            }
            sequenceBuilder.add(buffer);
        }
        return sequenceBuilder.toPositionSequence();
    }
}

