/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.cdi.se.bean;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.PassivationCapable;
import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.glassfish.jersey.JerseyPriorities;
import org.glassfish.jersey.innate.inject.InternalBinding;
import org.glassfish.jersey.internal.inject.PerLookup;
import org.glassfish.jersey.internal.inject.PerThread;
import org.jboss.weld.environment.se.contexts.ThreadScoped;

public abstract class JerseyBean<T>
implements Bean<T>,
PassivationCapable {
    static final Set<Annotation> DEFAULT_QUALIFIERS = new HashSet<Annotation>();
    private final InternalBinding<T, ?> binding;

    JerseyBean(InternalBinding<T, ?> binding) {
        this.binding = binding;
    }

    protected static Class<? extends Annotation> transformScope(Class<? extends Annotation> scope) {
        if (scope == PerLookup.class) {
            return Dependent.class;
        }
        if (scope == PerThread.class) {
            return ThreadScoped.class;
        }
        if (scope == org.glassfish.jersey.process.internal.RequestScoped.class) {
            return RequestScoped.class;
        }
        return scope;
    }

    public Set<Type> getTypes() {
        HashSet<Type> contracts = new HashSet<Type>();
        contracts.addAll(this.binding.getContracts());
        if (!this.binding.getAliases().isEmpty()) {
            this.binding.getAliases().forEach(alias -> contracts.add(alias.getContract()));
        }
        contracts.add((Type)((Object)Object.class));
        return contracts;
    }

    public Set<Annotation> getQualifiers() {
        HashSet<Annotation> qualifiers = new HashSet<Annotation>();
        qualifiers.addAll(DEFAULT_QUALIFIERS);
        if (this.binding.getQualifiers() != null) {
            qualifiers.addAll(this.binding.getQualifiers());
        }
        if (!this.binding.getAliases().isEmpty()) {
            this.binding.getAliases().forEach(alias -> qualifiers.addAll(alias.getQualifiers()));
        }
        return qualifiers;
    }

    public String getName() {
        return this.binding.getName();
    }

    public Class<? extends Annotation> getScope() {
        return Singleton.class;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    public boolean isNullable() {
        return false;
    }

    public void destroy(T instance, CreationalContext<T> creationalContext) {
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public int getRank() {
        if (this.binding.getRank() != null) {
            return this.binding.getRank();
        }
        int defaultValue = 1;
        Class type = this.binding.getImplementationType();
        if (type != null) {
            return JerseyPriorities.getPriorityValue((Class)type, (int)defaultValue);
        }
        return defaultValue;
    }

    public Class<?> getBeanClass() {
        return Object.class;
    }

    public String getId() {
        return this.getBeanClass().getTypeName() + "#jersey";
    }

    static {
        DEFAULT_QUALIFIERS.add((Annotation)new AnnotationLiteral<Default>(){});
        DEFAULT_QUALIFIERS.add((Annotation)new AnnotationLiteral<Any>(){});
    }
}

