/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.Bytes;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBCollectionImpl;
import com.mongodb.DBConnector;
import com.mongodb.DBObject;
import com.mongodb.DBPort;
import com.mongodb.DBTCPConnector;
import com.mongodb.Mongo;
import com.mongodb.MongoCredential;
import com.mongodb.MongoException;
import com.mongodb.OutMessage;
import com.mongodb.QueryResultIterator;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.ServerVersion;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class DBApiLayer
extends DB {
    static final int NUM_CURSORS_BEFORE_KILL = 100;
    static final int NUM_CURSORS_PER_BATCH = 20000;
    final String _root;
    final String _rootPlusDot;
    final DBTCPConnector _connector;
    final ConcurrentHashMap<String, DBCollectionImpl> _collections = new ConcurrentHashMap();
    ConcurrentLinkedQueue<DeadCursor> _deadCursorIds = new ConcurrentLinkedQueue();

    DBTCPConnector getConnector() {
        return this._connector;
    }

    protected DBApiLayer(Mongo mongo, String name, DBConnector connector) {
        super(mongo, name);
        if (connector == null) {
            throw new IllegalArgumentException("need a connector: " + name);
        }
        this._root = name;
        this._rootPlusDot = this._root + ".";
        this._connector = (DBTCPConnector)connector;
    }

    @Override
    public void requestStart() {
        this._connector.requestStart();
    }

    @Override
    public void requestDone() {
        this._connector.requestDone();
    }

    @Override
    public void requestEnsureConnection() {
        this._connector.requestEnsureConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WriteResult addUser(String username, char[] passwd, boolean readOnly) {
        this.requestStart();
        try {
            if (this.isServerVersionAtLeast(Arrays.asList(2, 6, 0))) {
                CommandResult userInfoResult;
                block7: {
                    userInfoResult = this.command(new BasicDBObject("usersInfo", username));
                    try {
                        userInfoResult.throwOnError();
                    }
                    catch (MongoException e) {
                        if (e.getCode() == 13) break block7;
                        throw e;
                    }
                }
                String operationType = !userInfoResult.containsField("users") || ((List)userInfoResult.get("users")).isEmpty() ? "createUser" : "updateUser";
                DBObject userCommandDocument = this.getUserCommandDocument(username, passwd, readOnly, operationType);
                CommandResult commandResult = this.command(userCommandDocument);
                commandResult.throwOnError();
                WriteResult writeResult = new WriteResult(commandResult, this.getWriteConcern());
                return writeResult;
            }
            WriteResult writeResult = super.addUser(username, passwd, readOnly);
            return writeResult;
        }
        finally {
            this.requestDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WriteResult removeUser(String username) {
        this.requestStart();
        try {
            if (this.isServerVersionAtLeast(Arrays.asList(2, 6, 0))) {
                CommandResult res = this.command(new BasicDBObject("dropUser", username));
                res.throwOnError();
                WriteResult writeResult = new WriteResult(res, this.getWriteConcern());
                return writeResult;
            }
            WriteResult writeResult = super.removeUser(username);
            return writeResult;
        }
        finally {
            this.requestDone();
        }
    }

    private DBObject getUserCommandDocument(String username, char[] passwd, boolean readOnly, String commandName) {
        return new BasicDBObject(commandName, username).append("pwd", this._hash(username, passwd)).append("digestPassword", false).append("roles", Arrays.asList(this.getUserRoleName(readOnly)));
    }

    private String getUserRoleName(boolean readOnly) {
        return this.getName().equals("admin") ? (readOnly ? "readAnyDatabase" : "root") : (readOnly ? "read" : "dbOwner");
    }

    @Override
    protected DBCollectionImpl doGetCollection(String name) {
        DBCollectionImpl c = this._collections.get(name);
        if (c != null) {
            return c;
        }
        c = new DBCollectionImpl(this, name);
        DBCollectionImpl old = this._collections.putIfAbsent(name, c);
        return old != null ? old : c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getCollectionNames() {
        this.requestStart();
        try {
            ArrayList<String> collectionNames = new ArrayList<String>();
            if (this.isServerVersionAtLeast(Arrays.asList(2, 7, 7))) {
                CommandResult res = this.command((DBObject)new BasicDBObject("listCollections", this.getName()), ReadPreference.primary());
                if (!res.ok() && res.getCode() != 26) {
                    res.throwOnError();
                } else {
                    List collections = (List)res.get("collections");
                    for (DBObject collectionInfo : collections) {
                        collectionNames.add(collectionInfo.get("name").toString());
                    }
                }
            } else {
                QueryResultIterator collections = this.getCollection("system.namespaces").find(new BasicDBObject(), null, 0, 0, 0, this.getOptions(), ReadPreference.primary(), null);
                while (collections.hasNext()) {
                    String collectionName = ((DBObject)collections.next()).get("name").toString();
                    if (collectionName.contains("$")) continue;
                    collectionNames.add(collectionName.substring(this.getName().length() + 1));
                }
            }
            Collections.sort(collectionNames);
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(collectionNames);
            return linkedHashSet;
        }
        finally {
            this.requestDone();
        }
    }

    @Override
    public void cleanCursors(boolean force) {
        DeadCursor c;
        int sz = this._deadCursorIds.size();
        if (sz == 0 || !force && sz < 100) {
            return;
        }
        Bytes.LOGGER.info("going to kill cursors : " + sz);
        HashMap<ServerAddress, LinkedList<Long>> m = new HashMap<ServerAddress, LinkedList<Long>>();
        while ((c = this._deadCursorIds.poll()) != null) {
            LinkedList<Long> x = (LinkedList<Long>)m.get(c.host);
            if (x == null) {
                x = new LinkedList<Long>();
                m.put(c.host, x);
            }
            x.add(c.id);
        }
        for (Map.Entry e : m.entrySet()) {
            try {
                this.killCursors((ServerAddress)e.getKey(), (List)e.getValue());
            }
            catch (Throwable t) {
                Bytes.LOGGER.log(Level.WARNING, "can't clean cursors", t);
                for (Long x : (List)e.getValue()) {
                    this._deadCursorIds.add(new DeadCursor(x, (ServerAddress)e.getKey()));
                }
            }
        }
    }

    void killCursors(ServerAddress addr, List<Long> all) {
        if (all == null || all.size() == 0) {
            return;
        }
        OutMessage om = OutMessage.killCursors(this._mongo, Math.min(20000, all.size()));
        int soFar = 0;
        int totalSoFar = 0;
        for (Long l : all) {
            om.writeLong(l);
            ++totalSoFar;
            if (++soFar < 20000) continue;
            this._connector.say(this, om, WriteConcern.NONE);
            om = OutMessage.killCursors(this._mongo, Math.min(20000, all.size() - totalSoFar));
            soFar = 0;
        }
        this._connector.say((DB)this, om, WriteConcern.NONE, addr);
    }

    @Override
    CommandResult doAuthenticate(MongoCredential credentials) {
        return this._connector.authenticate(credentials);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isServerVersionAtLeast(List<Integer> versionList) {
        DBPort primaryPort = this.getConnector().getPrimaryPort();
        try {
            boolean bl = this.getConnector().getServerDescription(primaryPort.getAddress()).getVersion().compareTo(new ServerVersion(versionList)) >= 0;
            return bl;
        }
        finally {
            this._connector.releasePort(primaryPort);
        }
    }

    void addDeadCursor(DeadCursor deadCursor) {
        this._deadCursorIds.add(deadCursor);
    }

    static class DeadCursor {
        final long id;
        final ServerAddress host;

        DeadCursor(long a, ServerAddress b) {
            this.id = a;
            this.host = b;
        }
    }
}

