/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.context;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.neo4j.ogm.annotation.RelationshipEntity;
import org.neo4j.ogm.context.GraphEntityMapper;
import org.neo4j.ogm.context.MappingContext;
import org.neo4j.ogm.context.ResponseMapper;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.model.GraphRowListModel;
import org.neo4j.ogm.model.GraphRowModel;
import org.neo4j.ogm.response.Response;
import org.neo4j.ogm.session.EntityInstantiator;

public class GraphRowListModelMapper
implements ResponseMapper<GraphRowListModel> {
    private final MetaData metaData;
    private final MappingContext mappingContext;
    private EntityInstantiator entityInstantiator;

    public GraphRowListModelMapper(MetaData metaData, MappingContext mappingContext, EntityInstantiator entityInstantiator) {
        this.metaData = metaData;
        this.mappingContext = mappingContext;
        this.entityInstantiator = entityInstantiator;
    }

    @Override
    public <T> Iterable<T> map(Class<T> type, Response<GraphRowListModel> response) {
        GraphRowListModel graphRowsModel;
        ArrayList<Object> result = new ArrayList<Object>();
        LinkedHashSet<Long> resultEntityIds = new LinkedHashSet<Long>();
        ClassInfo classInfo = this.metaData.classInfo(type.getName());
        LinkedHashSet<Long> nodeIds = new LinkedHashSet<Long>();
        LinkedHashSet<Long> edgeIds = new LinkedHashSet<Long>();
        GraphEntityMapper ogm = new GraphEntityMapper(this.metaData, this.mappingContext, this.entityInstantiator);
        while ((graphRowsModel = (GraphRowListModel)response.next()) != null) {
            for (GraphRowModel graphRowModel : graphRowsModel.model()) {
                Object[] rowData;
                ogm.map(type, graphRowModel.getGraph(), nodeIds, edgeIds);
                for (Object data : rowData = graphRowModel.getRow()) {
                    if (!(data instanceof Number)) continue;
                    resultEntityIds.add(((Number)data).longValue());
                }
            }
        }
        ogm.executePostLoad(nodeIds, edgeIds);
        if (classInfo.annotationsInfo().get(RelationshipEntity.class) == null) {
            for (Long resultEntityId : resultEntityIds) {
                result.add(this.mappingContext.getNodeEntity(resultEntityId));
            }
        } else {
            for (Long resultEntityId : resultEntityIds) {
                result.add(this.mappingContext.getRelationshipEntity(resultEntityId));
            }
        }
        return result;
    }
}

