/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

public class GenericUtils {
    public static Class findFieldType(Field field, Class concreteClass) {
        if (field.getGenericType() instanceof Class) {
            return field.getType();
        }
        TypeVariable<Class<?>>[] typeParameters = field.getDeclaringClass().getTypeParameters();
        for (int i = 0; i < typeParameters.length; ++i) {
            ParameterizedType genericSuperclass;
            if (!typeParameters[i].getName().equals(field.getGenericType().getTypeName()) || (genericSuperclass = GenericUtils.findMatchingSuperclass(concreteClass, field)) == null) continue;
            return (Class)genericSuperclass.getActualTypeArguments()[i];
        }
        return field.getType();
    }

    private static ParameterizedType findMatchingSuperclass(Class clazz, Field field) {
        Type superclass = clazz.getGenericSuperclass();
        if (superclass == null) {
            return null;
        }
        if (superclass instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)superclass;
            if (paramType.getRawType().equals(field.getDeclaringClass())) {
                return paramType;
            }
            return GenericUtils.findMatchingSuperclass(clazz.getSuperclass(), field);
        }
        return GenericUtils.findMatchingSuperclass(clazz.getSuperclass(), field);
    }
}

