/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.delegates;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.neo4j.ogm.context.EntityGraphMapper;
import org.neo4j.ogm.cypher.compiler.CompileContext;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.delegates.SaveEventDelegate;
import org.neo4j.ogm.session.request.RequestExecutor;

public class SaveDelegate {
    private final Neo4jSession session;
    private final RequestExecutor requestExecutor;

    public SaveDelegate(Neo4jSession neo4jSession) {
        this.session = neo4jSession;
        this.requestExecutor = new RequestExecutor(neo4jSession);
    }

    public <T> void save(T object) {
        this.save(object, -1);
    }

    /*
     * WARNING - void declaration
     */
    public <T> void save(T object, int depth) {
        SaveEventDelegate eventsDelegate = new SaveEventDelegate(this.session);
        if (object.getClass().isArray() || Iterable.class.isAssignableFrom(object.getClass())) {
            ArrayList<Object> objects;
            if (object.getClass().isArray()) {
                void var7_9;
                int length = Array.getLength(object);
                ArrayList<Object> copy = new ArrayList<Object>(length);
                boolean bl = false;
                while (var7_9 < length) {
                    Object arrayElement = Array.get(object, (int)var7_9);
                    copy.add(arrayElement);
                    ++var7_9;
                }
                objects = copy;
            } else {
                objects = (ArrayList<Object>)object;
            }
            EntityGraphMapper mapper = new EntityGraphMapper(this.session.metaData(), this.session.context());
            for (Object t : objects) {
                if (this.session.eventsEnabled()) {
                    eventsDelegate.preSave(object);
                }
                mapper.map(t, depth);
            }
            this.requestExecutor.executeSave(mapper.compileContext());
            if (this.session.eventsEnabled()) {
                eventsDelegate.postSave();
            }
        } else {
            ClassInfo classInfo = this.session.metaData().classInfo(object);
            if (classInfo != null) {
                if (this.session.eventsEnabled()) {
                    eventsDelegate.preSave(object);
                }
                CompileContext context = new EntityGraphMapper(this.session.metaData(), this.session.context()).map(object, depth);
                this.requestExecutor.executeSave(context);
                if (this.session.eventsEnabled()) {
                    eventsDelegate.postSave();
                }
            } else {
                throw new IllegalArgumentException("Class " + object.getClass() + " is not a valid entity class. Please check the entity mapping.");
            }
        }
    }
}

