/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore.qdrant;

import io.qdrant.client.ConditionFactory;
import io.qdrant.client.grpc.Points;
import java.util.ArrayList;
import java.util.List;
import org.springframework.ai.vectorstore.filter.Filter;

class QdrantFilterExpressionConverter {
    QdrantFilterExpressionConverter() {
    }

    public Points.Filter convertExpression(Filter.Expression expression) {
        return this.convertOperand((Filter.Operand)expression);
    }

    protected Points.Filter convertOperand(Filter.Operand operand) {
        Points.Filter.Builder context = Points.Filter.newBuilder();
        ArrayList<Points.Condition> mustClauses = new ArrayList<Points.Condition>();
        ArrayList<Points.Condition> shouldClauses = new ArrayList<Points.Condition>();
        ArrayList<Points.Condition> mustNotClauses = new ArrayList<Points.Condition>();
        if (operand instanceof Filter.Expression) {
            Filter.Operand operand2;
            Filter.Expression expression = (Filter.Expression)operand;
            if (expression.type() == Filter.ExpressionType.NOT && (operand2 = expression.left()) instanceof Filter.Group) {
                Filter.Group group = (Filter.Group)operand2;
                mustNotClauses.add(ConditionFactory.filter((Points.Filter)this.convertOperand((Filter.Operand)group.content())));
            } else if (expression.type() == Filter.ExpressionType.AND) {
                mustClauses.add(ConditionFactory.filter((Points.Filter)this.convertOperand(expression.left())));
                mustClauses.add(ConditionFactory.filter((Points.Filter)this.convertOperand(expression.right())));
            } else if (expression.type() == Filter.ExpressionType.OR) {
                shouldClauses.add(ConditionFactory.filter((Points.Filter)this.convertOperand(expression.left())));
                shouldClauses.add(ConditionFactory.filter((Points.Filter)this.convertOperand(expression.right())));
            } else {
                if (!(expression.right() instanceof Filter.Value)) {
                    throw new RuntimeException("Non AND/OR/NOT expression must have Value right argument!");
                }
                mustClauses.add(this.parseComparison((Filter.Key)expression.left(), (Filter.Value)expression.right(), expression));
            }
        }
        return context.addAllMust(mustClauses).addAllShould(shouldClauses).addAllMustNot(mustNotClauses).build();
    }

    protected Points.Condition parseComparison(Filter.Key key, Filter.Value value, Filter.Expression exp) {
        Filter.ExpressionType type = exp.type();
        switch (type) {
            case EQ: {
                return this.buildEqCondition(key, value);
            }
            case NE: {
                return this.buildNeCondition(key, value);
            }
            case GT: {
                return this.buildGtCondition(key, value);
            }
            case GTE: {
                return this.buildGteCondition(key, value);
            }
            case LT: {
                return this.buildLtCondition(key, value);
            }
            case LTE: {
                return this.buildLteCondition(key, value);
            }
            case IN: {
                return this.buildInCondition(key, value);
            }
            case NIN: {
                return this.buildNInCondition(key, value);
            }
        }
        throw new RuntimeException("Unsupported expression type: " + String.valueOf(type));
    }

    protected Points.Condition buildEqCondition(Filter.Key key, Filter.Value value) {
        String identifier = this.doKey(key);
        Object object = value.value();
        if (object instanceof String) {
            String valueStr = (String)object;
            return ConditionFactory.matchKeyword((String)identifier, (String)valueStr);
        }
        object = value.value();
        if (object instanceof Number) {
            Number valueNum = (Number)object;
            long lValue = Long.parseLong(valueNum.toString());
            return ConditionFactory.match((String)identifier, (long)lValue);
        }
        throw new IllegalArgumentException("Invalid value type for EQ. Can either be a string or Number");
    }

    protected Points.Condition buildNeCondition(Filter.Key key, Filter.Value value) {
        String identifier = this.doKey(key);
        Object object = value.value();
        if (object instanceof String) {
            String valueStr = (String)object;
            return ConditionFactory.filter((Points.Filter)Points.Filter.newBuilder().addMustNot(ConditionFactory.matchKeyword((String)identifier, (String)valueStr)).build());
        }
        object = value.value();
        if (object instanceof Number) {
            Number valueNum = (Number)object;
            long lValue = Long.parseLong(valueNum.toString());
            Points.Condition condition = ConditionFactory.match((String)identifier, (long)lValue);
            return ConditionFactory.filter((Points.Filter)Points.Filter.newBuilder().addMustNot(condition).build());
        }
        throw new IllegalArgumentException("Invalid value type for NEQ. Can either be a string or Number");
    }

    protected Points.Condition buildGtCondition(Filter.Key key, Filter.Value value) {
        String identifier = this.doKey(key);
        Object object = value.value();
        if (object instanceof Number) {
            Number valueNum = (Number)object;
            Double dvalue = Double.parseDouble(valueNum.toString());
            return ConditionFactory.range((String)identifier, (Points.Range)Points.Range.newBuilder().setGt(dvalue.doubleValue()).build());
        }
        throw new RuntimeException("Unsupported value type for GT condition. Only supports Number");
    }

    protected Points.Condition buildLtCondition(Filter.Key key, Filter.Value value) {
        String identifier = this.doKey(key);
        Object object = value.value();
        if (object instanceof Number) {
            Number valueNum = (Number)object;
            Double dvalue = Double.parseDouble(valueNum.toString());
            return ConditionFactory.range((String)identifier, (Points.Range)Points.Range.newBuilder().setLt(dvalue.doubleValue()).build());
        }
        throw new RuntimeException("Unsupported value type for LT condition. Only supports Number");
    }

    protected Points.Condition buildGteCondition(Filter.Key key, Filter.Value value) {
        String identifier = this.doKey(key);
        Object object = value.value();
        if (object instanceof Number) {
            Number valueNum = (Number)object;
            Double dvalue = Double.parseDouble(valueNum.toString());
            return ConditionFactory.range((String)identifier, (Points.Range)Points.Range.newBuilder().setGte(dvalue.doubleValue()).build());
        }
        throw new RuntimeException("Unsupported value type for GTE condition. Only supports Number");
    }

    protected Points.Condition buildLteCondition(Filter.Key key, Filter.Value value) {
        String identifier = this.doKey(key);
        Object object = value.value();
        if (object instanceof Number) {
            Number valueNum = (Number)object;
            Double dvalue = Double.parseDouble(valueNum.toString());
            return ConditionFactory.range((String)identifier, (Points.Range)Points.Range.newBuilder().setLte(dvalue.doubleValue()).build());
        }
        throw new RuntimeException("Unsupported value type for LTE condition. Only supports Number");
    }

    protected Points.Condition buildInCondition(Filter.Key key, Filter.Value value) {
        List valueList;
        Object object = value.value();
        if (object instanceof List && !(valueList = (List)object).isEmpty()) {
            Object firstValue = valueList.get(0);
            String identifier = this.doKey(key);
            if (firstValue instanceof String) {
                ArrayList<String> stringValues = new ArrayList<String>();
                for (Object valueObj : valueList) {
                    stringValues.add(valueObj.toString());
                }
                return ConditionFactory.matchKeywords((String)identifier, stringValues);
            }
            if (firstValue instanceof Number) {
                ArrayList<Long> longValues = new ArrayList<Long>();
                for (Object valueObj : valueList) {
                    Long longValue = Long.parseLong(valueObj.toString());
                    longValues.add(longValue);
                }
                return ConditionFactory.matchValues((String)identifier, longValues);
            }
            throw new RuntimeException("Unsupported value in IN value list. Only supports String or Number");
        }
        throw new RuntimeException("Unsupported value type for IN condition. Only supports non-empty List of String or Number");
    }

    protected Points.Condition buildNInCondition(Filter.Key key, Filter.Value value) {
        List valueList;
        Object object = value.value();
        if (object instanceof List && !(valueList = (List)object).isEmpty()) {
            Object firstValue = valueList.get(0);
            String identifier = this.doKey(key);
            if (firstValue instanceof String) {
                ArrayList<String> stringValues = new ArrayList<String>();
                for (Object valueObj : valueList) {
                    stringValues.add(valueObj.toString());
                }
                return ConditionFactory.matchExceptKeywords((String)identifier, stringValues);
            }
            if (firstValue instanceof Number) {
                ArrayList<Long> longValues = new ArrayList<Long>();
                for (Object valueObj : valueList) {
                    Long longValue = Long.parseLong(valueObj.toString());
                    longValues.add(longValue);
                }
                return ConditionFactory.matchExceptValues((String)identifier, longValues);
            }
            throw new RuntimeException("Unsupported value in NIN value list. Only supports String or Number");
        }
        throw new RuntimeException("Unsupported value type for NIN condition. Only supports non-empty List of String or Number");
    }

    protected String doKey(Filter.Key key) {
        String identifier = this.hasOuterQuotes(key.key()) ? this.removeOuterQuotes(key.key()) : key.key();
        return identifier;
    }

    protected boolean hasOuterQuotes(String str) {
        return (str = str.trim()).startsWith("\"") && str.endsWith("\"") || str.startsWith("'") && str.endsWith("'");
    }

    protected String removeOuterQuotes(String in) {
        return in.substring(1, in.length() - 1);
    }
}

