/*
 * Decompiled with CFR 0.152.
 */
package wicket.authentication.panel;

import wicket.Component;
import wicket.PageParameters;
import wicket.authentication.AuthenticatedWebSession;
import wicket.markup.html.WebMarkupContainer;
import wicket.markup.html.form.CheckBox;
import wicket.markup.html.form.Form;
import wicket.markup.html.form.PasswordTextField;
import wicket.markup.html.form.TextField;
import wicket.markup.html.panel.FeedbackPanel;
import wicket.markup.html.panel.Panel;
import wicket.model.IModel;
import wicket.model.PropertyModel;
import wicket.util.value.ValueMap;

public class SignInPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private boolean includeRememberMe = true;
    private PasswordTextField password;
    private boolean rememberMe = true;
    private TextField username;

    public SignInPanel(String id) {
        this(id, true);
    }

    public SignInPanel(String id, boolean includeRememberMe) {
        super(id);
        this.includeRememberMe = includeRememberMe;
        FeedbackPanel feedback = new FeedbackPanel("feedback");
        this.add((Component)feedback);
        this.add((Component)new SignInForm("signInForm"));
    }

    public final void forgetMe() {
        this.getPage().removePersistedFormData(SignInForm.class, true);
    }

    public String getPassword() {
        return this.password.getModelObjectAsString();
    }

    public boolean getRememberMe() {
        return this.rememberMe;
    }

    public String getUsername() {
        return this.username.getModelObjectAsString();
    }

    public void setPersistent(boolean enable) {
        this.username.setPersistent(enable);
        this.password.setPersistent(enable);
    }

    public void setRememberMe(boolean rememberMe) {
        this.rememberMe = rememberMe;
        this.setPersistent(rememberMe);
    }

    public boolean signIn(String username, String password) {
        return AuthenticatedWebSession.get().signIn(username, password);
    }

    protected void onSignInFailed() {
        this.error(this.getLocalizer().getString("signInFailed", (Component)this, "Sign in failed"));
    }

    protected void onSignInSucceeded() {
        if (!this.continueToOriginalDestination()) {
            this.setResponsePage(this.getApplication().getSessionSettings().getPageFactory().newPage(this.getApplication().getHomePage(), (PageParameters)null));
        }
    }

    public final class SignInForm
    extends Form {
        private static final long serialVersionUID = 1L;
        private final ValueMap properties;

        public SignInForm(String id) {
            super(id);
            this.properties = new ValueMap();
            this.add((Component)(SignInPanel.this.username = new TextField("username", (IModel)new PropertyModel((Object)this.properties, "username"))));
            this.add((Component)(SignInPanel.this.password = new PasswordTextField("password", (IModel)new PropertyModel((Object)this.properties, "password"))));
            WebMarkupContainer rememberMeRow = new WebMarkupContainer("rememberMeRow");
            this.add((Component)rememberMeRow);
            rememberMeRow.add((Component)new CheckBox("rememberMe", (IModel)new PropertyModel((Object)SignInPanel.this, "rememberMe")));
            SignInPanel.this.setPersistent(SignInPanel.this.rememberMe);
            rememberMeRow.setVisible(SignInPanel.this.includeRememberMe);
        }

        public final void onSubmit() {
            if (SignInPanel.this.signIn(SignInPanel.this.getUsername(), SignInPanel.this.getPassword())) {
                SignInPanel.this.onSignInSucceeded();
            } else {
                SignInPanel.this.onSignInFailed();
            }
        }
    }
}

