package cc.lechun.balance.api;

import cc.lechun.balance.dto.BalanceChangeDTO;
import cc.lechun.balance.dto.SpecialCardDTO;
import cc.lechun.framework.common.vo.BaseJsonVo;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.Map;

@RestController
@RequestMapping(value = "specialCard")
public interface SpecialCardApi {
    /**
     * 购买定向专用储值卡
     * 注意：需要分布式锁，需要考虑一致性和幂等性
     * @param customerId
     * @param orderMainNo
     * @return
     */
    @RequestMapping(value = "purchaseSpecialCard", method = {RequestMethod.POST, RequestMethod.GET})
    BaseJsonVo<SpecialCardDTO> purchaseSpecialCard(String customerId, String orderMainNo, BigDecimal chargeAmount, Integer batchType, Integer cardType, BigDecimal saleValue, BigDecimal rate);

    /**
     * 获取用户定向卡剩余点数
     * 注意：需要分布式锁，需要考虑一致性和幂等性
     * @param customerId
     * @param cardType
     * @return
     */
    @RequestMapping(value = "getSpecialTotal", method = {RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    BaseJsonVo<BigDecimal> getSpecialTotal(String customerId, Integer cardType);

    /**
     * 获取用户某个定向卡
     * 注意：需要分布式锁，需要考虑一致性和幂等性
     * @param cardNo
     * @return
     */
    @RequestMapping(value = "getSpecialCardRemain", method = {RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    Map<String,BigDecimal> getSpecialCardRemain(String cardNo);

    /**
     * 订单支付--使用定向卡
     * 注意：需要分布式锁，需要考虑一致性和幂等性
     * @param customerId
     * @return
     */
    @RequestMapping(value = "payOrderWithSpecialCard", method = {RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    BaseJsonVo<BalanceChangeDTO> payOrderWithSpecialCard(String customerId, String orderMainNo, String cardNo, BigDecimal orderAmount, Integer cardType);

    /**
     * 定向卡点卡取消订单返还点数
     * 注意：需要分布式锁，需要考虑一致性和幂等性
     * @param orderMainNo
     * @param cancelAmount
     * @param operator
     * @return
     */
    @RequestMapping(value = "cancelDirectionCardOrder", method = {RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    BaseJsonVo<BalanceChangeDTO> cancelDirectionCardOrder(String orderMainNo, BigDecimal cancelAmount, String operator);

    /**
     * 定向卡次卡订单退款
     * 注意：需要分布式锁，需要考虑一致性和幂等性
     * @param cardNo
     * @param orderMainNo
     * @param refundAmount
     * @param operator
     * @return
     */
    @RequestMapping(value = "cancelSpecialCardOrder", method = {RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    BaseJsonVo<BalanceChangeDTO> cancelSpecialCardOrder(String cardNo, String orderMainNo, BigDecimal refundAmount, String operator);

    /**
     * 定向卡订单退款
     * 注意：需要分布式锁，需要考虑一致性和幂等性
     * @param cardNo
     * @param orderMainNo
     * @param refundAmount
     * @param operator
     * @return
     */
    @RequestMapping(value = "refundSpecialCardOrder", method = {RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    BaseJsonVo<BalanceChangeDTO> refundSpecialCardOrder(String cardNo, String orderMainNo, BigDecimal refundAmount, String operator);
}
