package cc.lechun.balance.dto;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @Description:
 * @Author hans
 * @Date 2019/7/24 10:45
 * @Version 1.0
 */
public class BalanceChangeDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    String detailId;

    /**
     * 变更记录
     */
    UserBalanceDetailDTO userBalanceDetail;
    /**
     * 变更总金额
     */
    BigDecimal totalBalanceChange;
    /**
     * 变更储值金额
     */
    BigDecimal storeBalanceChange;
    /**
     * 变更赠送金额
     */
    BigDecimal freeBalanceChange;
    /**
     * 变更礼品卡金额
     */
    BigDecimal giftBalanceChange;

    /**
     * 变更定向专用卡金额
     */
    BigDecimal specialCardBalanceChange = BigDecimal.ZERO;

    List<BalanceChangeSpecialDTO> cardCost;

    public String getDetailId() {
        return detailId;
    }

    public void setDetailId(String detailId) {
        this.detailId = detailId;
    }

    public UserBalanceDetailDTO getUserBalanceDetail() {
        return userBalanceDetail;
    }

    public void setUserBalanceDetail(UserBalanceDetailDTO userBalanceDetail) {
        this.userBalanceDetail = userBalanceDetail;
    }

    public BigDecimal getTotalBalanceChange() {
        return totalBalanceChange;
    }

    public void setTotalBalanceChange(BigDecimal totalBalanceChange) {
        this.totalBalanceChange = totalBalanceChange;
    }

    public BigDecimal getStoreBalanceChange() {
        return storeBalanceChange;
    }

    public void setStoreBalanceChange(BigDecimal storeBalanceChange) {
        this.storeBalanceChange = storeBalanceChange;
    }

    public BigDecimal getFreeBalanceChange() {
        return freeBalanceChange;
    }

    public void setFreeBalanceChange(BigDecimal freeBalanceChange) {
        this.freeBalanceChange = freeBalanceChange;
    }

    public BigDecimal getGiftBalanceChange() {
        return giftBalanceChange;
    }

    public void setGiftBalanceChange(BigDecimal giftBalanceChange) {
        this.giftBalanceChange = giftBalanceChange;
    }

    public BigDecimal getSpecialCardBalanceChange() {
        return specialCardBalanceChange;
    }

    public void setSpecialCardBalanceChange(BigDecimal specialCardBalanceChange) {
        this.specialCardBalanceChange = specialCardBalanceChange;
    }

    public List<BalanceChangeSpecialDTO> getCardCost() {
        return cardCost;
    }

    public void setCardCost(List<BalanceChangeSpecialDTO> cardCost) {
        this.cardCost = cardCost;
    }
}
