package cc.lechun.balance.dto;

import com.fasterxml.jackson.annotation.JsonFormat;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Description:
 * @Author hans
 * @Date 2019/7/24 10:35
 * @Version 1.0
 */
public class UserBalanceDetailDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 聚合用户账户信息
     */
    UserBalanceDTO userBalance;

    List<UserBalanceDetailRecordDTO> records;

    public UserBalanceDTO getUserBalance() {
        return userBalance;
    }

    public void setUserBalance(UserBalanceDTO userBalance) {
        this.userBalance = userBalance;
    }

    public List<UserBalanceDetailRecordDTO> getRecords() {
        return records;
    }

    public void setRecords(List<UserBalanceDetailRecordDTO> records) {
        this.records = records;
    }

    public static class UserBalanceDetailRecordDTO implements Serializable {

        private static final long serialVersionUID = 1L;

        public UserBalanceDetailRecordDTO() {
        }

        /*子类型的说明*/
        private String title;

        /*变动金额*/
        private String cash;

        /*账户余额总额*/
        private String wealth;

        /*创建时间*/
        @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
        private Date time;

        /*变更后的余额*/
        private String usableWealth;

        /*第三方交易号*/
        private String tradeNo;

        public String getTitle() {
            return title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getCash() {
            return cash;
        }

        public void setCash(String cash) {
            this.cash = cash;
        }

        public String getWealth() {
            return wealth;
        }

        public void setWealth(String wealth) {
            this.wealth = wealth;
        }

        public Date getTime() {
            return time;
        }

        public void setTime(Date time) {
            this.time = time;
        }

        public String getUsableWealth() {
            return usableWealth;
        }

        public void setUsableWealth(String usableWealth) {
            this.usableWealth = usableWealth;
        }

        public String getTradeNo() {
            return tradeNo;
        }

        public void setTradeNo(String tradeNo) {
            this.tradeNo = tradeNo;
        }
    }
}