package cc.lechun.balance.api;

import cc.lechun.balance.dto.*;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.vo.BaseJsonVo;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * @Description:礼品卡接口，全部为CMS页面提供
 * @Author hans
 * @Date 2019/8/12 13:55
 * @Version 1.0
 */

public interface GiftCardManagerApi {

    //出库
    @RequestMapping(value = "/giftCard/processOutbound")
    BaseJsonVo processOutbound(GiftCardOutboundRecordInfoDTO giftCardOutbound)throws AuthorizeException;

    //入库
    @RequestMapping(value = "/giftCard/processInbound")
    BaseJsonVo processInbound(@RequestParam("file") MultipartFile file)throws AuthorizeException;

    @RequestMapping(value = "/giftCard/importInbound")
    BaseJsonVo importInbound(@RequestParam("list")List<GiftCardInfoDTO> list,@RequestParam("userId")String userId)throws AuthorizeException;

    /**
     * 查询所有礼品卡批次，包括销量
     * 注意：不需要缓存
     * @return
     */
    @RequestMapping(value = "/giftCard/findGiftCardBatches")
    BaseJsonVo<List<GiftCardBatchDTO>> findGiftCardBatches(PageForm pageForm, GiftCardBatchDTO giftCardBatchDTO);

    /**
     * 查询礼品卡批次的券码
     * 注意：不需要缓存
     * @return
     */
    @RequestMapping(value = "/giftCard/findGiftCards")
    BaseJsonVo<List<GiftCardDTO>> findGiftCards(PageForm pageForm, GiftCardDTO giftCardDTO);

    /**
     * 导出礼品卡批次的券码
     * 注意：不需要缓存
     * @return
     */
    @RequestMapping(value = "/giftCard/exportGiftCards")
    BaseJsonVo<List<GiftCardDTO>> exportGiftCards(String batchId);

    /**
     * 生成一批礼品卡
     * 注意：不需要缓存
     * @param batch
     * @return
     */
    @RequestMapping(value = "/giftCard/generateGiftCardBatch")
    BaseJsonVo<GiftCardBatchDTO> generateGiftCardBatch(GiftCardBatchDTO batch)throws AuthorizeException;

    /**
     * 生成一批礼品卡
     * 注意：不需要缓存
     * @param batch
     * @return
     */
    @RequestMapping(value = "/giftCard/updateGiftCardBatch")
    BaseJsonVo<GiftCardBatchDTO> updateGiftCardBatch(GiftCardBatchDTO batch);

    /**
     * 删除一批礼品卡
     * 注意：不需要缓存
     * @param batchId
     * @return
     */
    @RequestMapping(value = "/giftCard/delGiftCardBatch")
    BaseJsonVo delGiftCardBatch(String batchId);

    /**
     * 作废某一批次礼品卡
     * @param batchId
     * @return
     */
    @RequestMapping(value = "/giftCard/cancelGiftCardBatch")
    BaseJsonVo cancelGiftCardBatch(String batchId);

    /**
     * 作废某张礼品卡
     * 注意：不需要缓存
     * @param cardNo
     * @return
     */
    @RequestMapping(value = "/giftCard/invalidCard")
    BaseJsonVo invalidCard(String cardNo,int cardState);
}
