package cc.lechun.balance.api;

import cc.lechun.balance.dto.BalanceChangeDTO;
import cc.lechun.balance.dto.SpecialCardDTO;
import cc.lechun.framework.common.vo.BaseJsonVo;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping(value = "specialCard")
public interface SpecialCardApi {
    /**
     * 购买定向专用储值卡
     * 注意：需要分布式锁，需要考虑一致性和幂等性
     * @param customerId
     * @param orderMainNo
     * @return
     */
    @RequestMapping(value = "purchaseSpecialCard", method = {RequestMethod.POST, RequestMethod.GET})
    BaseJsonVo<SpecialCardDTO> purchaseSpecialCard(String customerId, String orderMainNo, BigDecimal chargeAmount, Integer batchType, Integer cardType, BigDecimal saleValue, BigDecimal rate);

    /**
     * 获取用户定向卡总点数和剩余点数
     * 注意：需要分布式锁，需要考虑一致性和幂等性
     * @param customerId
     * @param cardType
     * @return
     */
    @RequestMapping(value = "getSpecialAccount", method = {RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    Map<String,BigDecimal> getSpecialAccount(String customerId, Integer cardType);

    /**
     * 获取用户定向卡剩余点数
     * 注意：需要分布式锁，需要考虑一致性和幂等性
     * @param customerId
     * @param cardType
     * @return
     */
    @RequestMapping(value = "getSpecialTotal", method = {RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    BaseJsonVo<BigDecimal> getSpecialTotal(String customerId, Integer cardType);

    /**
     * 可用卡列表
     * @param customerId
     * @param cardType
     * @return
     */
    @RequestMapping(value = "getUsableSpecialList", method = {RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    BaseJsonVo<List<Map<String,Object>>> getUsableSpecialList(String customerId, Integer cardType);


    /**
     * 获取用户某个定向卡
     * 注意：需要分布式锁，需要考虑一致性和幂等性
     * @param cardNo
     * @return
     */
    @RequestMapping(value = "getSpecialCardRemain", method = {RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    Map<String,BigDecimal> getSpecialCardRemain(String cardNo);

    /**
     * 通过购买卡的订单号获取用户某个定向卡
     * 注意：需要分布式锁，需要考虑一致性和幂等性
     * @param orderMainNo
     * @return
     */
    @RequestMapping(value = "getSpecialCardRemainByOrderMainNo", method = {RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    Map<String,Object> getSpecialCardRemainByOrderMainNo(String orderMainNo);

    /**
     * 通过订单号获取使用的金额
     * @param orderMainNo
     * @return
     */
    @RequestMapping(value = "getSpecialCardCostByOrderMainNo", method = {RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    BigDecimal getSpecialCardCostByOrderMainNo(String orderMainNo);

    /**
     * 订单支付--使用定向卡
     * 注意：需要分布式锁，需要考虑一致性和幂等性
     * @param customerId
     * @return
     */
    @RequestMapping(value = "payOrderWithSpecialCard", method = {RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    BaseJsonVo<BalanceChangeDTO> payOrderWithSpecialCard(String customerId, String orderMainNo, String cardNo, BigDecimal orderAmount, Integer cardType);

    /**
     * 定向卡点卡取消订单返还点数
     * 注意：需要分布式锁，需要考虑一致性和幂等性
     * @param orderMainNo
     * @param cancelAmount
     * @param operator
     * @return
     */
    @RequestMapping(value = "cancelDirectionCardOrder", method = {RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    BaseJsonVo<BalanceChangeDTO> cancelDirectionCardOrder(String orderMainNo, BigDecimal cancelAmount, String operator);

    /**
     * 定向卡次卡订单退款
     * 注意：需要分布式锁，需要考虑一致性和幂等性
     * @param cardNo
     * @param orderMainNo
     * @param refundAmount
     * @param operator
     * @return
     */
    @RequestMapping(value = "cancelSpecialCardOrder", method = {RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    BaseJsonVo<BalanceChangeDTO> cancelSpecialCardOrder(String cardNo, String orderMainNo, BigDecimal refundAmount, String operator);

    /**
     * 定向卡订单退款
     * 注意：需要分布式锁，需要考虑一致性和幂等性
     * @param cardNo
     * @param refundAmount
     * @param operator
     * @return
     */
    @RequestMapping(value = "refundSpecialCardOrder", method = {RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    BaseJsonVo<BalanceChangeDTO> refundSpecialCardOrder(String cardNo, BigDecimal refundAmount, String operator);

    /**
     * 改变点卡/次卡状态，只能从1改为-1(禁用)，或-1改为1(解除禁用)
     * @param cardNo
     * @param status
     * @param operator
     * @return
     */
    @RequestMapping(value = "toggleSpecialCard", method = {RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    BaseJsonVo toggleSpecialCard(String cardNo, Integer status, String operator);

    /**
     * 改变点卡/次卡状态，只能从1改为-1(禁用)，或-1改为1(解除禁用)
     * @param orderMainNo
     * @param status
     * @param operator
     * @return
     */
    @RequestMapping(value = "toggleSpecialCardByCardOrderMainNo", method = {RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    BaseJsonVo toggleSpecialCardByCardOrderMainNo(String orderMainNo, Integer status, String operator);

    /**
     * 改变点卡/次卡所属人：暂时为抖店预付卡用户绑定奶卡设计
     * @param cardNo
     * @param status
     * @param operator
     * @return
     */
    @RequestMapping(value = "changeSpecialCardOwner", method = {RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    BaseJsonVo changeSpecialCardOwner(String cardNo, String exCustomerId, String newCustomerId);

    /**
     * 判断奶卡能省多少钱：限定卡类型只能是4、5/
     * @param cardNo
     * @param status
     * @param operator
     * @return
     */
    @RequestMapping(value = "getSpecialCardSave", method = {RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    BaseJsonVo getSpecialCardSave(String customerId, BigDecimal orderAmount, Integer cardType);

    /**
     * 删掉奶卡的记录
     * @param orderNo
     * @return
     */
    @RequestMapping(value = "delSpecialCardAndLog", method = {RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    BaseJsonVo delSpecialCardAndLog(String orderNo);
}
