package cc.lechun.balance.api;

import cc.lechun.balance.dto.GiftCardBatchDTO;
import cc.lechun.balance.dto.StorageCardDTO;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.vo.BaseJsonVo;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

/**
 * @Description:储值卡接口
 * @Author hans
 * @Date 2019/8/12 13:55
 * @Version 1.0
 */
@RequestMapping(value = "storage")
public interface StorageCardManagerApi {

    @RequestMapping(value = "findStorageCard")
    BaseJsonVo<List<StorageCardDTO>> findStorageCard(PageForm pageForm, StorageCardDTO storageCardDTO);

    @RequestMapping(value = "saveStorageCard")
    BaseJsonVo<List<StorageCardDTO>> saveStorageCard(StorageCardDTO storageCardDTO);

    /**
     * 查询所有储值卡批次，包括储值卡的销量，为CMS提供
     * 注意：不需要缓存
     * @return
     */
    BaseJsonVo<List<StorageCardDTO>> findStorageCardsWithSales();

    /**
     * 查询所有储值卡批次，不包括储值卡的销量，为前端提供
     * 注意：需要缓存，注意时效，生成/上下线需要清除缓存
     * @return
     */
    @RequestMapping(value = "findStorageCards")
    @ResponseBody
    BaseJsonVo<List<StorageCardDTO>> findStorageCards();

    /**
     * 生成一类储值卡
     * 注意：锁、一致性幂等性(重复提交)
     * @param storageCard
     * @return
     */
    BaseJsonVo generateStorageCard(StorageCardDTO storageCard);

    /**
     * 激活，上线某类储值卡
     * 注意：锁、一致性幂等性
     * @param cardId
     * @return
     */
    BaseJsonVo validCard(String cardId);

    /**
     * 下线某类储值卡
     * 注意：锁、一致性幂等性
     * @param cardId
     * @return
     */
    BaseJsonVo invalidCard(String cardId,int cardState);

    /**
     * 验证信息
     * @param giftTitle
     * @return
     */
    BaseJsonVo validationStorageInfo(String giftTitle);

    BaseJsonVo getStorageCardByProId(String proId);
}
