package cc.lechun.balance.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

/**
 * @Description:
 * @Author hans
 * @Date 2019/8/12 14:16
 * @Version 1.0
 */
public class GiftCardBatchDTO implements Serializable {

    private static final long serialVersionUID = -806819023900332495L;

    /*批次号*/
    private String batchNo;

    /*批次名称*/
    private String batchName;

    /*批次数量*/
    private Integer batchNum;

    /*金额*/
    private BigDecimal batchMoney;

    /*有效期*/
    private String cardValidity;

    /*开始时间*/
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date cardStartTime;

    /*结束时间*/
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date cardEndTime;

    /*用途*/
    private String batchUse;

    /*创建时间*/
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /*创建者*/
    private String createBy;

    /*更新时间*/
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    /*更新者*/
    private String updateBy;

    /*备注*/
    private String remark;

    public String getBatchNo() {
        return batchNo;
    }

    public void setBatchNo(String batchNo) {
        this.batchNo = batchNo;
    }

    public String getBatchName() {
        return batchName;
    }

    public void setBatchName(String batchName) {
        this.batchName = batchName;
    }

    public Integer getBatchNum() {
        return batchNum;
    }

    public void setBatchNum(Integer batchNum) {
        this.batchNum = batchNum;
    }

    public BigDecimal getBatchMoney() {
        return batchMoney;
    }

    public void setBatchMoney(BigDecimal batchMoney) {
        this.batchMoney = batchMoney;
    }

    public String getCardValidity() {
        return cardValidity;
    }

    public void setCardValidity(String cardValidity) {
        this.cardValidity = cardValidity;
    }

    public Date getCardStartTime() {
        return cardStartTime;
    }

    public void setCardStartTime(Date cardStartTime) {
        this.cardStartTime = cardStartTime;
    }

    public Date getCardEndTime() {
        return cardEndTime;
    }

    public void setCardEndTime(Date cardEndTime) {
        this.cardEndTime = cardEndTime;
    }

    public String getBatchUse() {
        return batchUse;
    }

    public void setBatchUse(String batchUse) {
        this.batchUse = batchUse;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getCreateBy() {
        return createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public String getRemark() {
        return remark;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getUpdateBy() {
        return updateBy;
    }

    public void setUpdateBy(String updateBy) {
        this.updateBy = updateBy;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", batchNo=").append(batchNo);
        sb.append(", batchName=").append(batchName);
        sb.append(", batchNum=").append(batchNum);
        sb.append(", batchMoney=").append(batchMoney);
        sb.append(", cardValidity=").append(cardValidity);
        sb.append(", cardStartTime=").append(cardStartTime);
        sb.append(", cardEndTime=").append(cardEndTime);
        sb.append(", batchUse=").append(batchUse);
        sb.append(", createTime=").append(createTime);
        sb.append(", createBy=").append(createBy);
        sb.append(", updateTime=").append(updateTime);
        sb.append(", updateBy=").append(updateBy);
        sb.append(", remark=").append(remark);
        sb.append(", serialVersionUID=").append(serialVersionUID);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        GiftCardBatchDTO other = (GiftCardBatchDTO) that;
        return (this.getBatchNo() == null ? other.getBatchNo() == null : this.getBatchNo().equals(other.getBatchNo()))
                && (this.getBatchName() == null ? other.getBatchName() == null : this.getBatchName().equals(other.getBatchName()))
                && (this.getBatchNum() == null ? other.getBatchNum() == null : this.getBatchNum().equals(other.getBatchNum()))
                && (this.getBatchMoney() == null ? other.getBatchMoney() == null : this.getBatchMoney().equals(other.getBatchMoney()))
                && (this.getCardValidity() == null ? other.getCardValidity() == null : this.getCardValidity().equals(other.getCardValidity()))
                && (this.getCardStartTime() == null ? other.getCardStartTime() == null : this.getCardStartTime().equals(other.getCardStartTime()))
                && (this.getCardEndTime() == null ? other.getCardEndTime() == null : this.getCardEndTime().equals(other.getCardEndTime()))
                && (this.getBatchUse() == null ? other.getBatchUse() == null : this.getBatchUse().equals(other.getBatchUse()))
                && (this.getCreateTime() == null ? other.getCreateTime() == null : this.getCreateTime().equals(other.getCreateTime()))
                && (this.getCreateBy() == null ? other.getCreateBy() == null : this.getCreateBy().equals(other.getCreateBy()))
                && (this.getUpdateTime() == null ? other.getUpdateTime() == null : this.getUpdateTime().equals(other.getUpdateTime()))
                && (this.getUpdateBy() == null ? other.getUpdateBy() == null : this.getUpdateBy().equals(other.getUpdateBy()))
                && (this.getRemark() == null ? other.getRemark() == null : this.getRemark().equals(other.getRemark()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getBatchNo() == null) ? 0 : getBatchNo().hashCode());
        result = prime * result + ((getBatchName() == null) ? 0 : getBatchName().hashCode());
        result = prime * result + ((getBatchNum() == null) ? 0 : getBatchNum().hashCode());
        result = prime * result + ((getBatchMoney() == null) ? 0 : getBatchMoney().hashCode());
        result = prime * result + ((getCardValidity() == null) ? 0 : getCardValidity().hashCode());
        result = prime * result + ((getCardStartTime() == null) ? 0 : getCardStartTime().hashCode());
        result = prime * result + ((getCardEndTime() == null) ? 0 : getCardEndTime().hashCode());
        result = prime * result + ((getBatchUse() == null) ? 0 : getBatchUse().hashCode());
        result = prime * result + ((getCreateTime() == null) ? 0 : getCreateTime().hashCode());
        result = prime * result + ((getCreateBy() == null) ? 0 : getCreateBy().hashCode());
        result = prime * result + ((getUpdateTime() == null) ? 0 : getUpdateTime().hashCode());
        result = prime * result + ((getUpdateBy() == null) ? 0 : getUpdateBy().hashCode());
        result = prime * result + ((getRemark() == null) ? 0 : getRemark().hashCode());
        return result;
    }

}
