/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.balance.api;

import cc.lechun.balance.api.StorageCardManagerApi;
import cc.lechun.balance.dto.StorageCardDTO;
import cc.lechun.balance.entity.storage.StorageCardEntity;
import cc.lechun.balance.iservice.storage.StorageCardInterface;
import cc.lechun.balance.tools.RandomUtils;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.vo.BaseJsonVo;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StorageCardManagerApiService
implements StorageCardManagerApi {
    @Autowired
    private StorageCardInterface storageCardInterface;

    public BaseJsonVo<List<StorageCardDTO>> findStorageCard(PageForm pageForm, StorageCardDTO storageCardDTO) {
        JSONObject jsonObject = new JSONObject();
        String batchDtoStr = JSONObject.toJSONString((Object)storageCardDTO);
        StorageCardEntity storageCardEntity = (StorageCardEntity)JSONObject.parseObject((String)batchDtoStr, StorageCardEntity.class);
        PageInfo pageInfo = this.storageCardInterface.queryStorageCardInfo(pageForm.getCurrentPage(), pageForm.getPageSize(), storageCardEntity);
        return BaseJsonVo.success((Object)pageInfo);
    }

    public BaseJsonVo<List<StorageCardDTO>> saveStorageCard(StorageCardDTO storageCardDTO) {
        JSONObject jsonObject = new JSONObject();
        String batchDtoStr = JSONObject.toJSONString((Object)storageCardDTO);
        StorageCardEntity storageCardEntity = (StorageCardEntity)JSONObject.parseObject((String)batchDtoStr, StorageCardEntity.class);
        storageCardEntity.setId(RandomUtils.generateNumber((int)12));
        Date nowDate = DateUtils.now();
        storageCardEntity.setCreateTime(nowDate);
        this.storageCardInterface.saveStorageCard(storageCardEntity);
        return BaseJsonVo.success((Object)"\u751f\u6210\u6210\u529f");
    }

    public BaseJsonVo<List<StorageCardDTO>> findStorageCardsWithSales() {
        return null;
    }

    public BaseJsonVo<List<StorageCardDTO>> findStorageCards() {
        StorageCardEntity storageCardEntity = new StorageCardEntity();
        storageCardEntity.setGiftState(Integer.valueOf(1));
        List storageCardEntityList = this.storageCardInterface.getList((Object)storageCardEntity);
        ArrayList<StorageCardDTO> storageCardDTOList = new ArrayList<StorageCardDTO>();
        if (storageCardEntityList != null && storageCardEntityList.size() > 0) {
            for (StorageCardEntity storageCard : storageCardEntityList) {
                StorageCardDTO storageCardDTO = new StorageCardDTO();
                storageCardDTO.setId(storageCard.getId());
                storageCardDTO.setGiftTitle(storageCard.getGiftTitle());
                storageCardDTO.setGiftImg(storageCard.getGiftImg());
                storageCardDTO.setGiftCash(storageCard.getGiftCash());
                storageCardDTO.setFreeCash(storageCard.getFreeCash());
                storageCardDTO.setGiftState(storageCard.getGiftState());
                storageCardDTO.setPlatformGroupId(storageCard.getPlatformGroupId());
                storageCardDTO.setCreateTime(storageCard.getCreateTime());
                storageCardDTO.setCreateBy(storageCard.getCreateBy());
                storageCardDTOList.add(storageCardDTO);
            }
        }
        return BaseJsonVo.success(storageCardDTOList);
    }

    public BaseJsonVo generateStorageCard(StorageCardDTO storageCardDto) {
        JSONObject jsonObject = new JSONObject();
        String storageCardDtoStr = JSONObject.toJSONString((Object)storageCardDto);
        StorageCardEntity storageCardEntity = (StorageCardEntity)JSONObject.parseObject((String)storageCardDtoStr, StorageCardEntity.class);
        this.storageCardInterface.createStorageCard(storageCardEntity);
        return BaseJsonVo.success((Object)"\u751f\u6210\u6210\u529f");
    }

    public BaseJsonVo validCard(String cardId) {
        this.storageCardInterface.updateStorageCard(cardId, 1);
        return BaseJsonVo.success((Object)"\u6210\u529f");
    }

    public BaseJsonVo invalidCard(String cardId, int cardState) {
        StorageCardEntity storageCardEntity = new StorageCardEntity();
        storageCardEntity.setId(cardId);
        List storageCardEntityList = this.storageCardInterface.queryStorageCardInfoList(storageCardEntity);
        if (storageCardEntityList != null && storageCardEntityList.size() > 0) {
            storageCardEntity = (StorageCardEntity)storageCardEntityList.get(0);
        }
        if (cardState == 1 && storageCardEntity.getGiftState() == 2) {
            storageCardEntity.setGiftState(Integer.valueOf(cardState));
            this.storageCardInterface.updateStorageCardState(storageCardEntity);
        }
        if (cardState == 2 && storageCardEntity.getGiftState() == 1) {
            storageCardEntity.setGiftState(Integer.valueOf(cardState));
            this.storageCardInterface.updateStorageCardState(storageCardEntity);
        }
        if (cardState == 0 && storageCardEntity.getGiftState() != 0) {
            storageCardEntity.setGiftState(Integer.valueOf(cardState));
            this.storageCardInterface.updateStorageCardState(storageCardEntity);
        }
        this.storageCardInterface.updateStorageCard(cardId, cardState);
        return BaseJsonVo.success((Object)"\u6210\u529f");
    }
}

