/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.balance.api;

import cc.lechun.balance.api.UserBalanceApi;
import cc.lechun.balance.common.constants.BalanceTypeEnum;
import cc.lechun.balance.common.constants.DetailTypeEnum;
import cc.lechun.balance.dto.BalanceChangeDTO;
import cc.lechun.balance.dto.UserBalanceDTO;
import cc.lechun.balance.dto.UserBalanceDetailDTO;
import cc.lechun.balance.entity.account.UserBalanceChangeEntity;
import cc.lechun.balance.entity.account.UserBalanceChangeEntityExample;
import cc.lechun.balance.entity.account.UserBalanceDetailEntity;
import cc.lechun.balance.entity.account.UserBalanceDetailEntityExample;
import cc.lechun.balance.entity.account.UserBalanceDetailReleEntity;
import cc.lechun.balance.entity.account.UserBalanceEntity;
import cc.lechun.balance.entity.gift.GiftCardEntity;
import cc.lechun.balance.entity.storage.StorageCardEntity;
import cc.lechun.balance.iservice.account.UserBalanceChangeInterface;
import cc.lechun.balance.iservice.account.UserBalanceDetailInterface;
import cc.lechun.balance.iservice.account.UserBalanceDetailReleInterface;
import cc.lechun.balance.iservice.account.UserBalanceInterface;
import cc.lechun.balance.iservice.gift.GiftCardInterface;
import cc.lechun.balance.iservice.storage.StorageCardInterface;
import cc.lechun.framework.common.utils.cache.RedisCacheUtil;
import cc.lechun.framework.common.utils.cache.RedisLockParameter;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.database.util.SpringContextUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserBalanceApiService
implements UserBalanceApi {
    private static final Logger log = LoggerFactory.getLogger(UserBalanceApi.class);
    @Autowired
    RedisCacheUtil redis;
    @Autowired
    UserBalanceInterface userBalanceInterface;
    @Autowired
    UserBalanceDetailInterface userBalanceDetailInterface;
    @Autowired
    UserBalanceChangeInterface userBalanceChangeInterface;
    @Autowired
    UserBalanceDetailReleInterface userBalanceDetailReleInterface;
    @Autowired
    StorageCardInterface storageCardInterface;
    @Autowired
    GiftCardInterface giftCardInterface;

    @Cacheable(value={"Balance"}, key="'BalanceAccount:'+#customerId")
    public BaseJsonVo<UserBalanceDTO> getUserBalance(String customerId) {
        UserBalanceDTO dto = (UserBalanceDTO)this.redis.get("BalanceAccount:" + customerId);
        if (dto != null) {
            return BaseJsonVo.success((Object)dto);
        }
        UserBalanceEntity userBalanceEntity = this.userBalanceInterface.selectByCustomerId(customerId);
        if (userBalanceEntity == null || userBalanceEntity.getBalanceState() == 0) {
            return BaseJsonVo.error((String)"\u8d26\u6237\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        }
        if (userBalanceEntity.getBalanceState() == 2) {
            return BaseJsonVo.error((String)"\u8d26\u6237\u5df2\u505c\u7528");
        }
        UserBalanceDTO userBalanceDTO = new UserBalanceDTO();
        userBalanceDTO.setCustomerId(userBalanceEntity.getCustomerId());
        userBalanceDTO.setBalanceState(userBalanceEntity.getBalanceState());
        userBalanceDTO.setCreateTime(userBalanceEntity.getCreateTime());
        userBalanceDTO.setUsableTotalBalance(userBalanceEntity.getUsableTotalBalance());
        userBalanceDTO.setUsableStoreBalance(userBalanceEntity.getUsableStoreBalance());
        userBalanceDTO.setUsableFreeBalance(userBalanceEntity.getUsableFreeBalance());
        userBalanceDTO.setUsableGifBalance(userBalanceEntity.getUsableGiftBalance());
        if (userBalanceDTO != null) {
            this.redis.set("BalanceAccount:" + customerId, (Object)userBalanceDTO, Long.valueOf(3600L));
        }
        return BaseJsonVo.success((Object)userBalanceDTO);
    }

    @Cacheable(value={"Balance"}, key="'BalanceAccountDetail:'+#customerId")
    public BaseJsonVo<UserBalanceDetailDTO> getUserBalanceDetail(String customerId) {
        UserBalanceDetailDTO dto = (UserBalanceDetailDTO)this.redis.get("BalanceAccountDetail:" + customerId);
        if (dto != null) {
            return BaseJsonVo.success((Object)dto);
        }
        BaseJsonVo userBalance = ((UserBalanceApiService)SpringContextUtil.getBean(this.getClass())).getUserBalance(customerId);
        if (!userBalance.isSuccess()) {
            return BaseJsonVo.error((String)userBalance.getMessage());
        }
        UserBalanceDetailEntity param = new UserBalanceDetailEntity();
        param.setCustomerId(customerId);
        List details = this.userBalanceDetailInterface.getList((Object)param);
        ArrayList records = new ArrayList();
        UserBalanceDetailDTO userBalanceDetail = new UserBalanceDetailDTO();
        if (details != null) {
            details.forEach(detail -> {
                UserBalanceDetailDTO.UserBalanceDetailRecordDTO record = new UserBalanceDetailDTO.UserBalanceDetailRecordDTO();
                record.setCash(detail.getDetailType() == 1 ? "+" : "-" + detail.getChangeMoney().toString());
                record.setTime(detail.getCreateTime());
                record.setWealth(detail.getAccountTotal().toString());
                record.setTitle(detail.getDetailSubTypeDesc());
                record.setTradeNo(detail.getTradeNo());
                record.setUsableWealth(((UserBalanceChangeEntity)this.userBalanceChangeInterface.selectByPrimaryKey((Serializable)((Object)detail.getId()))).getUsableMoney().toString());
                records.add(record);
            });
        }
        userBalanceDetail.setUserBalance((UserBalanceDTO)userBalance.getValue());
        userBalanceDetail.setRecords(records);
        if (userBalanceDetail != null && userBalanceDetail.getUserBalance() != null) {
            this.redis.set("BalanceAccountDetail:" + customerId, (Object)userBalanceDetail, Long.valueOf(3600L));
        }
        return BaseJsonVo.success((Object)userBalanceDetail);
    }

    @Transactional
    @CacheEvict(value={"Balance"})
    @Caching(evict={@CacheEvict(value={"Balance"}, key="'BalanceAccount:'+#customerId"), @CacheEvict(value={"Balance"}, key="'BalanceAccountDetail:'+#customerId")})
    public BaseJsonVo<BalanceChangeDTO> charge(@RedisLockParameter(order=0) String customerId, String orderMainNo, String productId) {
        StorageCardEntity storageCardEntity = this.storageCardInterface.selectByProductId(productId);
        if (storageCardEntity == null || storageCardEntity.getGiftCash() == null || storageCardEntity.getGiftCash().compareTo(BigDecimal.ZERO) == 0) {
            throw new RuntimeException("\u8be5\u50a8\u503c\u5361\u4e0d\u5b58\u5728");
        }
        if (storageCardEntity.getGiftState() == 0) {
            throw new RuntimeException("\u50a8\u503c\u5361\u5df2\u5220\u9664");
        }
        if (storageCardEntity.getGiftState() == 2) {
            throw new RuntimeException("\u50a8\u503c\u5361\u5df2\u505c\u7528");
        }
        BaseJsonVo userBalanceStore = this.userBalanceInterface.increaseAccount(customerId, storageCardEntity.getGiftCash(), BalanceTypeEnum.STORE, customerId, 2);
        if (!userBalanceStore.isSuccess()) {
            throw new RuntimeException(userBalanceStore.getMessage());
        }
        BaseJsonVo userBalanceFree = this.userBalanceInterface.increaseAccount(customerId, storageCardEntity.getFreeCash(), BalanceTypeEnum.FREE, customerId, 2);
        if (!userBalanceFree.isSuccess()) {
            throw new RuntimeException(userBalanceFree.getMessage());
        }
        UserBalanceDetailEntity detailStore = new UserBalanceDetailEntity();
        detailStore.setId(IDGenerate.getUniqueIdStr());
        detailStore.setCustomerId(customerId);
        detailStore.setDetailType(Integer.valueOf(DetailTypeEnum.STORE.getValue() / 1000));
        detailStore.setDetailSubType(Integer.valueOf(DetailTypeEnum.STORE.getValue()));
        detailStore.setDetailSubTypeDesc(DetailTypeEnum.STORE.getName());
        detailStore.setChangeMoney(storageCardEntity.getGiftCash());
        detailStore.setAccountTotal(((UserBalanceEntity)userBalanceStore.getValue()).getUsableTotalBalance());
        detailStore.setAccountStore(((UserBalanceEntity)userBalanceStore.getValue()).getUsableStoreBalance());
        detailStore.setAccountFree(((UserBalanceEntity)userBalanceStore.getValue()).getUsableFreeBalance());
        detailStore.setAccountGift(((UserBalanceEntity)userBalanceStore.getValue()).getUsableGiftBalance());
        detailStore.setTradeNo("");
        detailStore.setGiftId(storageCardEntity.getId());
        detailStore.setGiftTitle(storageCardEntity.getGiftTitle());
        detailStore.setCreateBy(customerId);
        detailStore.setCreateTime(new Date());
        detailStore.setUpdateBy("");
        detailStore.setUpdateTime(null);
        detailStore.setRemark(orderMainNo);
        BaseJsonVo userBalanceDetailStore = this.userBalanceDetailInterface.keepAccountDetail(detailStore);
        if (!userBalanceDetailStore.isSuccess()) {
            throw new RuntimeException(userBalanceDetailStore.getMessage());
        }
        UserBalanceDetailEntity detailFree = new UserBalanceDetailEntity();
        detailFree.setId(IDGenerate.getUniqueIdStr());
        detailFree.setCustomerId(customerId);
        detailFree.setDetailType(Integer.valueOf(DetailTypeEnum.STORE_FREE.getValue() / 1000));
        detailFree.setDetailSubType(Integer.valueOf(DetailTypeEnum.STORE_FREE.getValue()));
        detailFree.setDetailSubTypeDesc(DetailTypeEnum.STORE_FREE.getName());
        detailFree.setChangeMoney(storageCardEntity.getFreeCash());
        detailFree.setAccountTotal(((UserBalanceEntity)userBalanceFree.getValue()).getUsableTotalBalance());
        detailFree.setAccountStore(((UserBalanceEntity)userBalanceFree.getValue()).getUsableStoreBalance());
        detailFree.setAccountFree(((UserBalanceEntity)userBalanceFree.getValue()).getUsableFreeBalance());
        detailFree.setAccountGift(((UserBalanceEntity)userBalanceFree.getValue()).getUsableGiftBalance());
        detailFree.setTradeNo("");
        detailFree.setGiftId(storageCardEntity.getId());
        detailFree.setGiftTitle(storageCardEntity.getGiftTitle());
        detailFree.setCreateBy(customerId);
        detailFree.setCreateTime(detailStore.getCreateTime());
        detailFree.setUpdateBy("");
        detailFree.setUpdateTime(null);
        detailFree.setRemark(orderMainNo);
        BaseJsonVo userBalanceDetailFree = this.userBalanceDetailInterface.keepAccountDetail(detailFree);
        if (!userBalanceDetailFree.isSuccess()) {
            throw new RuntimeException(userBalanceDetailFree.getMessage());
        }
        BaseJsonVo userBalanceChangeStore = this.userBalanceChangeInterface.keepAccountChange(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getId(), storageCardEntity.getGiftCash(), customerId);
        if (!userBalanceChangeStore.isSuccess()) {
            throw new RuntimeException(userBalanceChangeStore.getMessage());
        }
        BaseJsonVo userBalanceChangeFree = this.userBalanceChangeInterface.keepAccountChange(((UserBalanceDetailEntity)userBalanceDetailFree.getValue()).getId(), storageCardEntity.getFreeCash(), customerId);
        if (!userBalanceChangeFree.isSuccess()) {
            throw new RuntimeException(userBalanceChangeFree.getMessage());
        }
        BaseJsonVo cleanResult = this.cleanBalanceCache(customerId);
        if (!cleanResult.isSuccess()) {
            throw new RuntimeException(cleanResult.getMessage());
        }
        UserBalanceDTO dto = new UserBalanceDTO();
        dto.setCustomerId(customerId);
        dto.setUsableTotalBalance(((UserBalanceEntity)userBalanceFree.getValue()).getUsableTotalBalance());
        dto.setUsableStoreBalance(((UserBalanceEntity)userBalanceFree.getValue()).getUsableStoreBalance());
        dto.setUsableFreeBalance(((UserBalanceEntity)userBalanceFree.getValue()).getUsableFreeBalance());
        dto.setUsableGifBalance(((UserBalanceEntity)userBalanceFree.getValue()).getUsableGiftBalance());
        dto.setBalanceState(((UserBalanceEntity)userBalanceFree.getValue()).getBalanceState());
        UserBalanceDetailDTO detailDTO = new UserBalanceDetailDTO();
        ArrayList<UserBalanceDetailDTO.UserBalanceDetailRecordDTO> records = new ArrayList<UserBalanceDetailDTO.UserBalanceDetailRecordDTO>();
        UserBalanceDetailDTO.UserBalanceDetailRecordDTO detailRecordDTOStore = new UserBalanceDetailDTO.UserBalanceDetailRecordDTO();
        detailRecordDTOStore.setCash(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getDetailType() == 1 ? "+" : "-" + ((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getChangeMoney().toString());
        detailRecordDTOStore.setTime(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getCreateTime());
        detailRecordDTOStore.setWealth(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getAccountTotal().toString());
        detailRecordDTOStore.setTitle(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getDetailSubTypeDesc());
        records.add(detailRecordDTOStore);
        UserBalanceDetailDTO.UserBalanceDetailRecordDTO detailRecordDTOFree = new UserBalanceDetailDTO.UserBalanceDetailRecordDTO();
        detailRecordDTOFree.setCash(((UserBalanceDetailEntity)userBalanceDetailFree.getValue()).getDetailType() == 1 ? "+" : "-" + ((UserBalanceDetailEntity)userBalanceDetailFree.getValue()).getChangeMoney().toString());
        detailRecordDTOFree.setTime(((UserBalanceDetailEntity)userBalanceDetailFree.getValue()).getCreateTime());
        detailRecordDTOFree.setWealth(((UserBalanceDetailEntity)userBalanceDetailFree.getValue()).getAccountTotal().toString());
        detailRecordDTOFree.setTitle(((UserBalanceDetailEntity)userBalanceDetailFree.getValue()).getDetailSubTypeDesc());
        records.add(detailRecordDTOFree);
        detailDTO.setUserBalance(dto);
        detailDTO.setRecords(records);
        BalanceChangeDTO changeDTO = new BalanceChangeDTO();
        changeDTO.setUserBalanceDetail(detailDTO);
        changeDTO.setTotalBalanceChange(storageCardEntity.getGiftCash().add(storageCardEntity.getFreeCash()));
        changeDTO.setStoreBalanceChange(storageCardEntity.getGiftCash());
        changeDTO.setFreeBalanceChange(storageCardEntity.getFreeCash());
        changeDTO.setGiftBalanceChange(BigDecimal.ZERO);
        return BaseJsonVo.success((Object)changeDTO);
    }

    @Transactional
    @Caching(evict={@CacheEvict(value={"Balance"}, key="'BalanceAccount:'+#customerId"), @CacheEvict(value={"Balance"}, key="'BalanceAccountDetail:'+#customerId")})
    public BaseJsonVo<BalanceChangeDTO> cardCharge(String customerId, String cardNo) {
        GiftCardEntity card = (GiftCardEntity)this.giftCardInterface.selectByPrimaryKey((Serializable)((Object)cardNo));
        if (card == null || card.getCardCash().compareTo(BigDecimal.ZERO) <= 0) {
            return BaseJsonVo.error((String)"\u5361\u53f7\u4e0d\u5b58\u5728");
        }
        if (card.getCardState() == -1) {
            return BaseJsonVo.error((String)"\u5361\u53f7\u65e0\u6548");
        }
        if (card.getCardState() == -1) {
            return BaseJsonVo.error((String)"\u8be5\u5361\u5df2\u88ab\u6fc0\u6d3b");
        }
        if (card.getCardStartTime().compareTo(new Date()) > 0) {
            return BaseJsonVo.error((String)"\u672a\u5230\u6fc0\u6d3b\u65e5\u671f");
        }
        if (card.getCardEndTime().compareTo(new Date()) < 0) {
            return BaseJsonVo.error((String)"\u5361\u5df2\u8fc7\u671f");
        }
        card.setCardState(Integer.valueOf(1));
        card.setActivateTime(new Date());
        card.setCustomerId(customerId);
        card.setUpdateTime(card.getActivateTime());
        card.setUpdateBy(customerId);
        this.giftCardInterface.updateByPrimaryKey((Object)card);
        BaseJsonVo userBalance = this.userBalanceInterface.increaseAccount(customerId, card.getCardCash(), BalanceTypeEnum.GIFT, customerId, 2);
        if (!userBalance.isSuccess()) {
            return BaseJsonVo.error((String)userBalance.getMessage());
        }
        BaseJsonVo userBalanceDetail = this.userBalanceDetailInterface.keepAccountDetail(DetailTypeEnum.GIFT_CHARGE, BalanceTypeEnum.GIFT, customerId, card.getCardCash(), customerId, DetailTypeEnum.GIFT_CHARGE.getName(), ((UserBalanceEntity)userBalance.getValue()).getUsableTotalBalance(), ((UserBalanceEntity)userBalance.getValue()).getUsableStoreBalance(), ((UserBalanceEntity)userBalance.getValue()).getUsableFreeBalance(), ((UserBalanceEntity)userBalance.getValue()).getUsableGiftBalance(), "");
        if (!userBalanceDetail.isSuccess()) {
            return BaseJsonVo.error((String)userBalanceDetail.getMessage());
        }
        BaseJsonVo userBalanceChange = this.userBalanceChangeInterface.keepAccountChange(((UserBalanceDetailEntity)userBalanceDetail.getValue()).getId(), card.getCardCash(), customerId);
        if (!userBalanceChange.isSuccess()) {
            return BaseJsonVo.error((String)userBalanceChange.getMessage());
        }
        BaseJsonVo cleanResult = this.cleanBalanceCache(customerId);
        if (!cleanResult.isSuccess()) {
            return BaseJsonVo.error((String)cleanResult.getMessage());
        }
        UserBalanceDTO dto = new UserBalanceDTO();
        dto.setCustomerId(customerId);
        dto.setUsableTotalBalance(((UserBalanceEntity)userBalance.getValue()).getUsableTotalBalance());
        dto.setUsableStoreBalance(((UserBalanceEntity)userBalance.getValue()).getUsableStoreBalance());
        dto.setUsableFreeBalance(((UserBalanceEntity)userBalance.getValue()).getUsableFreeBalance());
        dto.setUsableGifBalance(((UserBalanceEntity)userBalance.getValue()).getUsableGiftBalance());
        dto.setBalanceState(((UserBalanceEntity)userBalance.getValue()).getBalanceState());
        UserBalanceDetailDTO detailDTO = new UserBalanceDetailDTO();
        UserBalanceDetailDTO.UserBalanceDetailRecordDTO detailRecordDTO = new UserBalanceDetailDTO.UserBalanceDetailRecordDTO();
        ArrayList<UserBalanceDetailDTO.UserBalanceDetailRecordDTO> records = new ArrayList<UserBalanceDetailDTO.UserBalanceDetailRecordDTO>();
        detailRecordDTO.setCash(((UserBalanceDetailEntity)userBalanceDetail.getValue()).getDetailType() == 1 ? "+" : "-" + ((UserBalanceDetailEntity)userBalanceDetail.getValue()).getChangeMoney().toString());
        detailRecordDTO.setTime(((UserBalanceDetailEntity)userBalanceDetail.getValue()).getCreateTime());
        detailRecordDTO.setWealth(((UserBalanceDetailEntity)userBalanceDetail.getValue()).getAccountTotal().toString());
        detailRecordDTO.setTitle(((UserBalanceDetailEntity)userBalanceDetail.getValue()).getDetailSubTypeDesc());
        records.add(detailRecordDTO);
        detailDTO.setUserBalance(dto);
        detailDTO.setRecords(records);
        BalanceChangeDTO changeDTO = new BalanceChangeDTO();
        changeDTO.setUserBalanceDetail(detailDTO);
        changeDTO.setTotalBalanceChange(card.getCardCash());
        changeDTO.setStoreBalanceChange(BigDecimal.ZERO);
        changeDTO.setFreeBalanceChange(card.getCardCash());
        changeDTO.setGiftBalanceChange(BigDecimal.ZERO);
        return BaseJsonVo.success((Object)changeDTO);
    }

    @Transactional
    @Caching(evict={@CacheEvict(value={"Balance"}, key="'BalanceAccount:'+#customerId"), @CacheEvict(value={"Balance"}, key="'BalanceAccountDetail:'+#customerId")})
    public BaseJsonVo<BalanceChangeDTO> payOrder(@RedisLockParameter(order=0) String customerId, String tradeNo, BigDecimal orderAmount) {
        UserBalanceEntity userBalanceEntity = this.userBalanceInterface.selectByCustomerId(customerId);
        if (userBalanceEntity == null || userBalanceEntity.getBalanceState() == 0) {
            throw new RuntimeException("\u8d26\u6237\u5df2\u5220\u9664");
        }
        if (userBalanceEntity.getBalanceState() == 2) {
            throw new RuntimeException("\u8d26\u6237\u5df2\u505c\u7528");
        }
        if (userBalanceEntity.getUsableTotalBalance().compareTo(orderAmount) < 0) {
            throw new RuntimeException("\u4f59\u989d\u4e0d\u8db3");
        }
        BaseJsonVo changes = this.userBalanceChangeInterface.findChanges(customerId);
        if (!changes.isSuccess()) {
            throw new RuntimeException(changes.getMessage());
        }
        log.info(((List)changes.getValue()).stream().map(UserBalanceChangeEntity::getUsableMoney).reduce(BigDecimal.ZERO, BigDecimal::add).toString());
        log.info(userBalanceEntity.getUsableTotalBalance().toString());
        if (((List)changes.getValue()).stream().map(UserBalanceChangeEntity::getUsableMoney).reduce(BigDecimal.ZERO, BigDecimal::add).compareTo(userBalanceEntity.getUsableTotalBalance()) != 0) {
            throw new RuntimeException("\u8d26\u6237\u4f59\u989d\u4e0e\u5269\u4f59\u91d1\u989d\u4e0d\u7b26");
        }
        String detailId = IDGenerate.getUniqueIdStr();
        BigDecimal storeOrderAmount = BigDecimal.ZERO;
        BigDecimal giftOrderAmount = BigDecimal.ZERO;
        BigDecimal freeOrderAmount = BigDecimal.ZERO;
        BigDecimal remainOrderAmount = orderAmount;
        for (UserBalanceChangeEntity change : (List)changes.getValue()) {
            UserBalanceDetailReleEntity rele;
            UserBalanceDetailEntity detail;
            if (remainOrderAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
            if (change.getUsableMoney().compareTo(remainOrderAmount) >= 0) {
                detail = (UserBalanceDetailEntity)this.userBalanceDetailInterface.selectByPrimaryKey((Serializable)((Object)change.getDetailId()));
                if (detail.getDetailSubType().intValue() == DetailTypeEnum.STORE.getValue()) {
                    storeOrderAmount = storeOrderAmount.add(remainOrderAmount);
                } else if (detail.getDetailSubType().intValue() == DetailTypeEnum.GIFT_CHARGE.getValue()) {
                    giftOrderAmount = giftOrderAmount.add(remainOrderAmount);
                } else {
                    freeOrderAmount = freeOrderAmount.add(remainOrderAmount);
                }
                this.userBalanceChangeInterface.consume(change.getDetailId(), customerId, remainOrderAmount);
                rele = new UserBalanceDetailReleEntity();
                rele.setId(IDGenerate.getUniqueIdStr());
                rele.setExpendId(detailId);
                rele.setIncomeId(change.getDetailId());
                rele.setPayMoney(remainOrderAmount);
                rele.setCreateBy(customerId);
                rele.setCreateTime(new Date());
                this.userBalanceDetailReleInterface.insert((Object)rele);
                remainOrderAmount = BigDecimal.ZERO;
                break;
            }
            detail = (UserBalanceDetailEntity)this.userBalanceDetailInterface.selectByPrimaryKey((Serializable)((Object)change.getDetailId()));
            if (detail.getDetailSubType().intValue() == DetailTypeEnum.STORE.getValue()) {
                storeOrderAmount = storeOrderAmount.add(change.getUsableMoney());
            } else if (detail.getDetailSubType().intValue() == DetailTypeEnum.GIFT_CHARGE.getValue()) {
                giftOrderAmount = giftOrderAmount.add(change.getUsableMoney());
            } else {
                freeOrderAmount = freeOrderAmount.add(change.getUsableMoney());
            }
            this.userBalanceChangeInterface.consume(change.getDetailId(), customerId, change.getUsableMoney());
            rele = new UserBalanceDetailReleEntity();
            rele.setId(IDGenerate.getUniqueIdStr());
            rele.setExpendId(detailId);
            rele.setIncomeId(change.getDetailId());
            rele.setPayMoney(change.getUsableMoney());
            rele.setCreateBy(customerId);
            rele.setCreateTime(new Date());
            this.userBalanceDetailReleInterface.insert((Object)rele);
            remainOrderAmount = remainOrderAmount.subtract(change.getUsableMoney());
        }
        if (storeOrderAmount.compareTo(BigDecimal.ZERO) > 0) {
            BaseJsonVo userBalanceStore = this.userBalanceInterface.decreaseAccount(customerId, storeOrderAmount, BalanceTypeEnum.STORE, customerId, 2);
            if (!userBalanceStore.isSuccess()) {
                throw new RuntimeException(userBalanceStore.getMessage());
            }
            userBalanceEntity = (UserBalanceEntity)userBalanceStore.getValue();
        }
        if (giftOrderAmount.compareTo(BigDecimal.ZERO) > 0) {
            BaseJsonVo userBalanceGift = this.userBalanceInterface.decreaseAccount(customerId, giftOrderAmount, BalanceTypeEnum.GIFT, customerId, 2);
            if (!userBalanceGift.isSuccess()) {
                throw new RuntimeException(userBalanceGift.getMessage());
            }
            userBalanceEntity = (UserBalanceEntity)userBalanceGift.getValue();
        }
        if (freeOrderAmount.compareTo(BigDecimal.ZERO) > 0) {
            BaseJsonVo userBalanceFree = this.userBalanceInterface.decreaseAccount(customerId, freeOrderAmount, BalanceTypeEnum.FREE, customerId, 2);
            if (!userBalanceFree.isSuccess()) {
                throw new RuntimeException(userBalanceFree.getMessage());
            }
            userBalanceEntity = (UserBalanceEntity)userBalanceFree.getValue();
        }
        UserBalanceDetailEntity detail = new UserBalanceDetailEntity();
        detail.setId(detailId);
        detail.setCustomerId(customerId);
        detail.setDetailType(Integer.valueOf(DetailTypeEnum.ORDER.getValue() / 1000));
        detail.setDetailSubType(Integer.valueOf(DetailTypeEnum.ORDER.getValue()));
        detail.setDetailSubTypeDesc(DetailTypeEnum.ORDER.getName());
        detail.setChangeMoney(orderAmount);
        detail.setAccountTotal(userBalanceEntity.getUsableTotalBalance());
        detail.setAccountStore(userBalanceEntity.getUsableStoreBalance());
        detail.setAccountFree(userBalanceEntity.getUsableFreeBalance());
        detail.setAccountGift(userBalanceEntity.getUsableGiftBalance());
        detail.setTradeNo(tradeNo);
        detail.setDetailStatus(Integer.valueOf(0));
        detail.setCreateBy(customerId);
        detail.setCreateTime(new Date());
        detail.setUpdateBy("");
        detail.setUpdateTime(null);
        detail.setRemark("");
        BaseJsonVo userBalanceDetailStore = this.userBalanceDetailInterface.keepAccountDetail(detail);
        if (!userBalanceDetailStore.isSuccess()) {
            throw new RuntimeException(userBalanceDetailStore.getMessage());
        }
        BaseJsonVo cleanResult = this.cleanBalanceCache(customerId);
        if (!cleanResult.isSuccess()) {
            throw new RuntimeException(cleanResult.getMessage());
        }
        UserBalanceDTO dto = new UserBalanceDTO();
        dto.setCustomerId(customerId);
        dto.setUsableTotalBalance(userBalanceEntity.getUsableTotalBalance());
        dto.setUsableStoreBalance(userBalanceEntity.getUsableStoreBalance());
        dto.setUsableFreeBalance(userBalanceEntity.getUsableFreeBalance());
        dto.setUsableGifBalance(userBalanceEntity.getUsableGiftBalance());
        dto.setBalanceState(userBalanceEntity.getBalanceState());
        UserBalanceDetailDTO detailDTO = new UserBalanceDetailDTO();
        ArrayList<UserBalanceDetailDTO.UserBalanceDetailRecordDTO> records = new ArrayList<UserBalanceDetailDTO.UserBalanceDetailRecordDTO>();
        UserBalanceDetailDTO.UserBalanceDetailRecordDTO detailRecordDTO = new UserBalanceDetailDTO.UserBalanceDetailRecordDTO();
        detailRecordDTO.setCash(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getDetailType() == 1 ? "+" : "-" + ((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getChangeMoney().toString());
        detailRecordDTO.setTime(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getCreateTime());
        detailRecordDTO.setWealth(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getAccountTotal().toString());
        detailRecordDTO.setTitle(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getDetailSubTypeDesc());
        records.add(detailRecordDTO);
        detailDTO.setUserBalance(dto);
        detailDTO.setRecords(records);
        BalanceChangeDTO changeDTO = new BalanceChangeDTO();
        changeDTO.setUserBalanceDetail(detailDTO);
        changeDTO.setTotalBalanceChange(orderAmount);
        changeDTO.setStoreBalanceChange(storeOrderAmount);
        changeDTO.setFreeBalanceChange(freeOrderAmount);
        changeDTO.setGiftBalanceChange(giftOrderAmount);
        return BaseJsonVo.success((Object)changeDTO);
    }

    @Transactional
    @Caching(evict={@CacheEvict(value={"Balance"}, key="'BalanceAccount:'+#customerId"), @CacheEvict(value={"Balance"}, key="'BalanceAccountDetail:'+#customerId")})
    public BaseJsonVo<BalanceChangeDTO> cancleOrder(String customerId, String tradeNo) {
        log.info("customerId : " + customerId);
        log.info("tradeNo : " + tradeNo);
        UserBalanceDetailEntity paramDetail = new UserBalanceDetailEntity();
        paramDetail.setTradeNo(tradeNo);
        List expendList = this.userBalanceDetailInterface.getList((Object)paramDetail);
        if (expendList == null || expendList.size() != 1) {
            throw new RuntimeException("\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728");
        }
        String expendDetailId = ((UserBalanceDetailEntity)expendList.get(0)).getId();
        UserBalanceDetailReleEntity paramRele = new UserBalanceDetailReleEntity();
        paramRele.setExpendId(expendDetailId);
        List incomeReleDetails = this.userBalanceDetailReleInterface.getList((Object)paramRele);
        if (incomeReleDetails == null || incomeReleDetails.size() == 0) {
            throw new RuntimeException("\u8ba2\u5355\u6263\u51cf\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        BigDecimal[] storeAmount = new BigDecimal[]{BigDecimal.ZERO};
        BigDecimal[] giftAmount = new BigDecimal[]{BigDecimal.ZERO};
        BigDecimal[] freeAmount = new BigDecimal[]{BigDecimal.ZERO};
        incomeReleDetails.forEach(rele -> {
            rele.setCancelMoney(rele.getPayMoney());
            rele.setUpdateBy(customerId);
            rele.setUpdateTime(new Date());
            this.userBalanceDetailReleInterface.updateByPrimaryKey(rele);
            UserBalanceChangeEntity change = (UserBalanceChangeEntity)this.userBalanceChangeInterface.selectByPrimaryKey((Serializable)((Object)rele.getIncomeId()));
            if (change == null) {
                throw new RuntimeException("\u8ba2\u5355\u6263\u51cf\u4f59\u989d\u8bb0\u5f55\u4e0d\u5b58\u5728");
            }
            change.setUsableMoney(change.getUsableMoney().add(rele.getPayMoney()));
            this.userBalanceChangeInterface.updateByPrimaryKey((Object)change);
            UserBalanceDetailEntity incomeDetail = (UserBalanceDetailEntity)this.userBalanceDetailInterface.selectByPrimaryKey((Serializable)((Object)rele.getIncomeId()));
            incomeDetail.setDetailStatus(Integer.valueOf(1));
            this.userBalanceDetailInterface.updateByPrimaryKey((Object)incomeDetail);
            switch (incomeDetail.getDetailSubType()) {
                case 1001: {
                    storeAmount[0] = storeAmount[0].add(rele.getPayMoney());
                    break;
                }
                case 1003: {
                    giftAmount[0] = giftAmount[0].add(rele.getPayMoney());
                    break;
                }
                default: {
                    freeAmount[0] = freeAmount[0].add(rele.getPayMoney());
                }
            }
        });
        BaseJsonVo balance = BaseJsonVo.success((Object)"");
        if (storeAmount[0].compareTo(BigDecimal.ZERO) > 0) {
            balance = this.userBalanceInterface.increaseAccount(customerId, storeAmount[0], BalanceTypeEnum.STORE, customerId, 1);
        }
        if (giftAmount[0].compareTo(BigDecimal.ZERO) > 0) {
            balance = this.userBalanceInterface.increaseAccount(customerId, giftAmount[0], BalanceTypeEnum.GIFT, customerId, 1);
        }
        if (freeAmount[0].compareTo(BigDecimal.ZERO) > 0) {
            balance = this.userBalanceInterface.increaseAccount(customerId, freeAmount[0], BalanceTypeEnum.FREE, customerId, 1);
        }
        UserBalanceDetailEntity detail = new UserBalanceDetailEntity();
        detail.setId(IDGenerate.getUniqueIdStr());
        detail.setCustomerId(customerId);
        detail.setDetailType(Integer.valueOf(DetailTypeEnum.ORDER_CANCEL.getValue() / 1000));
        detail.setDetailSubType(Integer.valueOf(DetailTypeEnum.ORDER_CANCEL.getValue()));
        detail.setDetailSubTypeDesc(DetailTypeEnum.ORDER_CANCEL.getName());
        detail.setChangeMoney(((UserBalanceDetailEntity)expendList.get(0)).getChangeMoney());
        detail.setAccountTotal(((UserBalanceEntity)balance.getValue()).getUsableTotalBalance());
        detail.setAccountStore(((UserBalanceEntity)balance.getValue()).getUsableStoreBalance());
        detail.setAccountFree(((UserBalanceEntity)balance.getValue()).getUsableFreeBalance());
        detail.setAccountGift(((UserBalanceEntity)balance.getValue()).getUsableGiftBalance());
        detail.setTradeNo(tradeNo);
        detail.setCreateBy(customerId);
        detail.setCreateTime(new Date());
        detail.setUpdateBy("");
        detail.setUpdateTime(null);
        detail.setRemark("");
        BaseJsonVo userBalanceDetailStore = this.userBalanceDetailInterface.keepAccountDetail(detail);
        if (!userBalanceDetailStore.isSuccess()) {
            throw new RuntimeException(userBalanceDetailStore.getMessage());
        }
        BaseJsonVo cleanResult = this.cleanBalanceCache(customerId);
        if (!cleanResult.isSuccess()) {
            throw new RuntimeException(cleanResult.getMessage());
        }
        UserBalanceDTO dto = new UserBalanceDTO();
        dto.setCustomerId(customerId);
        dto.setUsableTotalBalance(((UserBalanceEntity)balance.getValue()).getUsableTotalBalance());
        dto.setUsableStoreBalance(((UserBalanceEntity)balance.getValue()).getUsableStoreBalance());
        dto.setUsableFreeBalance(((UserBalanceEntity)balance.getValue()).getUsableFreeBalance());
        dto.setUsableGifBalance(((UserBalanceEntity)balance.getValue()).getUsableGiftBalance());
        dto.setBalanceState(((UserBalanceEntity)balance.getValue()).getBalanceState());
        UserBalanceDetailDTO detailDTO = new UserBalanceDetailDTO();
        ArrayList<UserBalanceDetailDTO.UserBalanceDetailRecordDTO> records = new ArrayList<UserBalanceDetailDTO.UserBalanceDetailRecordDTO>();
        UserBalanceDetailDTO.UserBalanceDetailRecordDTO detailRecordDTO = new UserBalanceDetailDTO.UserBalanceDetailRecordDTO();
        detailRecordDTO.setCash(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getDetailType() == 1 ? "+" : "-" + ((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getChangeMoney().toString());
        detailRecordDTO.setTime(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getCreateTime());
        detailRecordDTO.setWealth(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getAccountTotal().toString());
        detailRecordDTO.setTitle(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getDetailSubTypeDesc());
        records.add(detailRecordDTO);
        detailDTO.setUserBalance(dto);
        detailDTO.setRecords(records);
        BalanceChangeDTO changeDTO = new BalanceChangeDTO();
        changeDTO.setUserBalanceDetail(detailDTO);
        changeDTO.setTotalBalanceChange(((UserBalanceDetailEntity)expendList.get(0)).getChangeMoney());
        changeDTO.setStoreBalanceChange(storeAmount[0]);
        changeDTO.setFreeBalanceChange(freeAmount[0]);
        changeDTO.setGiftBalanceChange(giftAmount[0]);
        return BaseJsonVo.success((Object)changeDTO);
    }

    @Transactional
    @Caching(evict={@CacheEvict(value={"Balance"}, key="'BalanceAccount:'+#customerId"), @CacheEvict(value={"Balance"}, key="'BalanceAccountDetail:'+#customerId")})
    public BaseJsonVo<BalanceChangeDTO> refundOrder(String customerId, String tradeNo, BigDecimal refundAmount, String operator) {
        UserBalanceDetailEntity paramDetail = new UserBalanceDetailEntity();
        paramDetail.setTradeNo(tradeNo);
        List expendList = this.userBalanceDetailInterface.getList((Object)paramDetail);
        if (expendList == null || expendList.size() != 1) {
            throw new RuntimeException("\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728");
        }
        String expendDetailId = ((UserBalanceDetailEntity)expendList.get(0)).getId();
        UserBalanceDetailReleEntity paramRele = new UserBalanceDetailReleEntity();
        paramRele.setExpendId(expendDetailId);
        List incomeReleDetails = this.userBalanceDetailReleInterface.getList((Object)paramRele);
        if (incomeReleDetails == null || incomeReleDetails.size() == 0) {
            throw new RuntimeException("\u8ba2\u5355\u6263\u51cf\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        BigDecimal[] storeAmount = new BigDecimal[]{BigDecimal.ZERO};
        BigDecimal[] giftAmount = new BigDecimal[]{BigDecimal.ZERO};
        BigDecimal[] freeAmount = new BigDecimal[]{BigDecimal.ZERO};
        BigDecimal[] remainRefundAmount = new BigDecimal[]{refundAmount};
        for (int i = incomeReleDetails.size() - 1; i >= 0; --i) {
            UserBalanceDetailEntity incomeDetail;
            UserBalanceChangeEntity change;
            UserBalanceDetailReleEntity rele = (UserBalanceDetailReleEntity)incomeReleDetails.get(i);
            if (rele.getPayMoney().compareTo(remainRefundAmount[0]) >= 0) {
                rele.setRefundMoney(remainRefundAmount[0]);
                rele.setUpdateBy(operator);
                rele.setUpdateTime(new Date());
                this.userBalanceDetailReleInterface.updateByPrimaryKey((Object)rele);
                change = (UserBalanceChangeEntity)this.userBalanceChangeInterface.selectByPrimaryKey((Serializable)((Object)rele.getIncomeId()));
                if (change == null) {
                    throw new RuntimeException("\u8ba2\u5355\u6263\u51cf\u4f59\u989d\u8bb0\u5f55\u4e0d\u5b58\u5728");
                }
                change.setUsableMoney(change.getUsableMoney().add(remainRefundAmount[0]));
                this.userBalanceChangeInterface.updateByPrimaryKey((Object)change);
                incomeDetail = (UserBalanceDetailEntity)this.userBalanceDetailInterface.selectByPrimaryKey((Serializable)((Object)rele.getIncomeId()));
                incomeDetail.setDetailStatus(Integer.valueOf(2));
                this.userBalanceDetailInterface.updateByPrimaryKey((Object)incomeDetail);
                switch (incomeDetail.getDetailSubType()) {
                    case 1001: {
                        storeAmount[0] = storeAmount[0].add(remainRefundAmount[0]);
                        break;
                    }
                    case 1003: {
                        giftAmount[0] = giftAmount[0].add(remainRefundAmount[0]);
                        break;
                    }
                    default: {
                        freeAmount[0] = freeAmount[0].add(remainRefundAmount[0]);
                    }
                }
                remainRefundAmount[0] = BigDecimal.ZERO;
                break;
            }
            rele.setRefundMoney(rele.getPayMoney());
            rele.setUpdateBy(operator);
            rele.setUpdateTime(new Date());
            this.userBalanceDetailReleInterface.updateByPrimaryKey((Object)rele);
            change = (UserBalanceChangeEntity)this.userBalanceChangeInterface.selectByPrimaryKey((Serializable)((Object)rele.getIncomeId()));
            if (change == null) {
                throw new RuntimeException("\u8ba2\u5355\u6263\u51cf\u4f59\u989d\u8bb0\u5f55\u4e0d\u5b58\u5728");
            }
            change.setUsableMoney(change.getUsableMoney().add(rele.getPayMoney()));
            this.userBalanceChangeInterface.updateByPrimaryKey((Object)change);
            incomeDetail = (UserBalanceDetailEntity)this.userBalanceDetailInterface.selectByPrimaryKey((Serializable)((Object)rele.getIncomeId()));
            incomeDetail.setDetailStatus(Integer.valueOf(2));
            this.userBalanceDetailInterface.updateByPrimaryKey((Object)incomeDetail);
            switch (incomeDetail.getDetailSubType()) {
                case 1001: {
                    storeAmount[0] = storeAmount[0].add(rele.getPayMoney());
                    break;
                }
                case 1003: {
                    giftAmount[0] = giftAmount[0].add(rele.getPayMoney());
                    break;
                }
                default: {
                    freeAmount[0] = freeAmount[0].add(rele.getPayMoney());
                }
            }
            remainRefundAmount[0] = remainRefundAmount[0].subtract(rele.getPayMoney());
        }
        BaseJsonVo balance = BaseJsonVo.success((Object)"");
        if (storeAmount[0].compareTo(BigDecimal.ZERO) > 0) {
            balance = this.userBalanceInterface.increaseAccount(customerId, storeAmount[0], BalanceTypeEnum.STORE, customerId, 1);
        }
        if (giftAmount[0].compareTo(BigDecimal.ZERO) > 0) {
            balance = this.userBalanceInterface.increaseAccount(customerId, giftAmount[0], BalanceTypeEnum.GIFT, customerId, 1);
        }
        if (freeAmount[0].compareTo(BigDecimal.ZERO) > 0) {
            balance = this.userBalanceInterface.increaseAccount(customerId, freeAmount[0], BalanceTypeEnum.FREE, customerId, 1);
        }
        UserBalanceDetailEntity detail = new UserBalanceDetailEntity();
        detail.setId(IDGenerate.getUniqueIdStr());
        detail.setCustomerId(customerId);
        detail.setDetailType(Integer.valueOf(DetailTypeEnum.ORDER_REFUND.getValue() / 1000));
        detail.setDetailSubType(Integer.valueOf(DetailTypeEnum.ORDER_REFUND.getValue()));
        detail.setDetailSubTypeDesc(DetailTypeEnum.ORDER_REFUND.getName());
        detail.setChangeMoney(((UserBalanceDetailEntity)expendList.get(0)).getChangeMoney());
        detail.setAccountTotal(((UserBalanceEntity)balance.getValue()).getUsableTotalBalance());
        detail.setAccountStore(((UserBalanceEntity)balance.getValue()).getUsableStoreBalance());
        detail.setAccountFree(((UserBalanceEntity)balance.getValue()).getUsableFreeBalance());
        detail.setAccountGift(((UserBalanceEntity)balance.getValue()).getUsableGiftBalance());
        detail.setTradeNo(tradeNo);
        detail.setCreateBy(customerId);
        detail.setCreateTime(new Date());
        detail.setUpdateBy("");
        detail.setUpdateTime(null);
        detail.setRemark("");
        BaseJsonVo userBalanceDetailStore = this.userBalanceDetailInterface.keepAccountDetail(detail);
        if (!userBalanceDetailStore.isSuccess()) {
            throw new RuntimeException(userBalanceDetailStore.getMessage());
        }
        BaseJsonVo cleanResult = this.cleanBalanceCache(customerId);
        if (!cleanResult.isSuccess()) {
            throw new RuntimeException(cleanResult.getMessage());
        }
        UserBalanceDTO dto = new UserBalanceDTO();
        dto.setCustomerId(customerId);
        dto.setUsableTotalBalance(((UserBalanceEntity)balance.getValue()).getUsableTotalBalance());
        dto.setUsableStoreBalance(((UserBalanceEntity)balance.getValue()).getUsableStoreBalance());
        dto.setUsableFreeBalance(((UserBalanceEntity)balance.getValue()).getUsableFreeBalance());
        dto.setUsableGifBalance(((UserBalanceEntity)balance.getValue()).getUsableGiftBalance());
        dto.setBalanceState(((UserBalanceEntity)balance.getValue()).getBalanceState());
        UserBalanceDetailDTO detailDTO = new UserBalanceDetailDTO();
        ArrayList<UserBalanceDetailDTO.UserBalanceDetailRecordDTO> records = new ArrayList<UserBalanceDetailDTO.UserBalanceDetailRecordDTO>();
        UserBalanceDetailDTO.UserBalanceDetailRecordDTO detailRecordDTO = new UserBalanceDetailDTO.UserBalanceDetailRecordDTO();
        detailRecordDTO.setCash(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getDetailType() == 1 ? "+" : "-" + ((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getChangeMoney().toString());
        detailRecordDTO.setTime(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getCreateTime());
        detailRecordDTO.setWealth(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getAccountTotal().toString());
        detailRecordDTO.setTitle(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getDetailSubTypeDesc());
        records.add(detailRecordDTO);
        detailDTO.setUserBalance(dto);
        detailDTO.setRecords(records);
        BalanceChangeDTO changeDTO = new BalanceChangeDTO();
        changeDTO.setUserBalanceDetail(detailDTO);
        changeDTO.setTotalBalanceChange(((UserBalanceDetailEntity)expendList.get(0)).getChangeMoney());
        changeDTO.setStoreBalanceChange(storeAmount[0]);
        changeDTO.setFreeBalanceChange(freeAmount[0]);
        changeDTO.setGiftBalanceChange(giftAmount[0]);
        return BaseJsonVo.success((Object)changeDTO);
    }

    @Transactional
    @Caching(evict={@CacheEvict(value={"Balance"}, key="'BalanceAccount:'+#customerId"), @CacheEvict(value={"Balance"}, key="'BalanceAccountDetail:'+#customerId")})
    public BaseJsonVo<BalanceChangeDTO> refundCharge(String customerId, String tradeNo, String operator) {
        UserBalanceDetailEntityExample detailStoreExample = new UserBalanceDetailEntityExample();
        detailStoreExample.createCriteria().andTradeNoEqualTo(tradeNo).andDetailSubTypeEqualTo(Integer.valueOf(DetailTypeEnum.STORE.getValue()));
        List storeDetails = this.userBalanceDetailInterface.selectByExample((Object)detailStoreExample);
        if (storeDetails == null || storeDetails.size() != 1) {
            throw new RuntimeException("\u4e0d\u5b58\u5728\u8be5\u50a8\u503c\u6216\u8be5\u50a8\u503c\u5927\u4e8e1\u6761");
        }
        UserBalanceChangeEntityExample changeStoreExample = new UserBalanceChangeEntityExample();
        changeStoreExample.createCriteria().andDetailIdEqualTo(((UserBalanceDetailEntity)storeDetails.get(0)).getId());
        List storeChanges = this.userBalanceChangeInterface.selectByExample((Object)changeStoreExample);
        if (storeChanges == null || storeChanges.size() != 1) {
            throw new RuntimeException("\u4e0d\u5b58\u5728\u8be5\u50a8\u503c\u5269\u4f59\u6216\u8be5\u50a8\u503c\u5269\u4f59\u5927\u4e8e1\u6761");
        }
        if (((UserBalanceChangeEntity)storeChanges.get(0)).getUsableMoney().compareTo(BigDecimal.ZERO) <= 0) {
            throw new RuntimeException("\u8be5\u50a8\u503c\u5df2\u7528\u5b8c");
        }
        BigDecimal remainStoreAmount = ((UserBalanceChangeEntity)storeChanges.get(0)).getUsableMoney();
        UserBalanceDetailEntityExample detailFreeExample = new UserBalanceDetailEntityExample();
        detailFreeExample.createCriteria().andTradeNoEqualTo(tradeNo).andDetailSubTypeEqualTo(Integer.valueOf(DetailTypeEnum.STORE_FREE.getValue()));
        List freeDetails = this.userBalanceDetailInterface.selectByExample((Object)detailFreeExample);
        UserBalanceChangeEntityExample changeFreeExample = new UserBalanceChangeEntityExample();
        changeFreeExample.createCriteria().andDetailIdEqualTo(((UserBalanceDetailEntity)freeDetails.get(0)).getId());
        List freeChanges = this.userBalanceChangeInterface.selectByExample((Object)changeFreeExample);
        BigDecimal remainFreeAmount = ((UserBalanceChangeEntity)freeChanges.get(0)).getUsableMoney();
        BaseJsonVo userBalanceStore = this.userBalanceInterface.decreaseAccount(customerId, remainStoreAmount, BalanceTypeEnum.STORE, operator, 1);
        if (!userBalanceStore.isSuccess()) {
            throw new RuntimeException(userBalanceStore.getMessage());
        }
        BaseJsonVo userBalanceFree = this.userBalanceInterface.decreaseAccount(customerId, remainFreeAmount, BalanceTypeEnum.FREE, operator, 1);
        if (!userBalanceFree.isSuccess()) {
            throw new RuntimeException(userBalanceFree.getMessage());
        }
        UserBalanceDetailEntity detailStore = new UserBalanceDetailEntity();
        detailStore.setId(IDGenerate.getUniqueIdStr());
        detailStore.setCustomerId(customerId);
        detailStore.setDetailType(Integer.valueOf(DetailTypeEnum.STORE_REFUND.getValue() / 1000));
        detailStore.setDetailSubType(Integer.valueOf(DetailTypeEnum.STORE_REFUND.getValue()));
        detailStore.setDetailSubTypeDesc(DetailTypeEnum.STORE_REFUND.getName());
        detailStore.setChangeMoney(remainStoreAmount);
        detailStore.setAccountTotal(((UserBalanceEntity)userBalanceStore.getValue()).getUsableTotalBalance());
        detailStore.setAccountStore(((UserBalanceEntity)userBalanceStore.getValue()).getUsableStoreBalance());
        detailStore.setAccountFree(((UserBalanceEntity)userBalanceStore.getValue()).getUsableFreeBalance());
        detailStore.setAccountGift(((UserBalanceEntity)userBalanceStore.getValue()).getUsableGiftBalance());
        detailStore.setTradeNo(tradeNo);
        detailStore.setGiftId(((UserBalanceDetailEntity)storeDetails.get(0)).getGiftId());
        detailStore.setGiftTitle(((UserBalanceDetailEntity)storeDetails.get(0)).getGiftTitle());
        detailStore.setCreateBy(operator);
        detailStore.setCreateTime(new Date());
        detailStore.setUpdateBy("");
        detailStore.setUpdateTime(null);
        detailStore.setRemark("");
        BaseJsonVo userBalanceDetailStore = this.userBalanceDetailInterface.keepAccountDetail(detailStore);
        if (!userBalanceDetailStore.isSuccess()) {
            throw new RuntimeException(userBalanceDetailStore.getMessage());
        }
        UserBalanceDetailEntity detailFree = new UserBalanceDetailEntity();
        detailFree.setId(IDGenerate.getUniqueIdStr());
        detailFree.setCustomerId(customerId);
        detailFree.setDetailType(Integer.valueOf(DetailTypeEnum.STORE_REFUND_REDUCT_CASHBACK.getValue() / 1000));
        detailFree.setDetailSubType(Integer.valueOf(DetailTypeEnum.STORE_REFUND_REDUCT_CASHBACK.getValue()));
        detailFree.setDetailSubTypeDesc(DetailTypeEnum.STORE_REFUND_REDUCT_CASHBACK.getName());
        detailFree.setChangeMoney(remainFreeAmount);
        detailFree.setAccountTotal(((UserBalanceEntity)userBalanceFree.getValue()).getUsableTotalBalance());
        detailFree.setAccountStore(((UserBalanceEntity)userBalanceFree.getValue()).getUsableStoreBalance());
        detailFree.setAccountFree(((UserBalanceEntity)userBalanceFree.getValue()).getUsableFreeBalance());
        detailFree.setAccountGift(((UserBalanceEntity)userBalanceFree.getValue()).getUsableGiftBalance());
        detailFree.setTradeNo(tradeNo);
        detailFree.setGiftId(((UserBalanceDetailEntity)storeDetails.get(0)).getGiftId());
        detailFree.setGiftTitle(((UserBalanceDetailEntity)storeDetails.get(0)).getGiftTitle());
        detailFree.setCreateBy(operator);
        detailFree.setCreateTime(new Date());
        detailFree.setUpdateBy("");
        detailFree.setUpdateTime(null);
        detailFree.setRemark("");
        BaseJsonVo userBalanceDetailFree = this.userBalanceDetailInterface.keepAccountDetail(detailFree);
        if (!userBalanceDetailFree.isSuccess()) {
            throw new RuntimeException(userBalanceDetailFree.getMessage());
        }
        UserBalanceChangeEntity storeChange = (UserBalanceChangeEntity)storeChanges.get(0);
        storeChange.setUsableMoney(BigDecimal.ZERO);
        this.userBalanceChangeInterface.updateByPrimaryKey((Object)storeChange);
        UserBalanceChangeEntity freeChange = (UserBalanceChangeEntity)freeChanges.get(0);
        freeChange.setUsableMoney(BigDecimal.ZERO);
        this.userBalanceChangeInterface.updateByPrimaryKey((Object)freeChange);
        BaseJsonVo cleanResult = this.cleanBalanceCache(customerId);
        if (!cleanResult.isSuccess()) {
            throw new RuntimeException(cleanResult.getMessage());
        }
        UserBalanceDTO dto = new UserBalanceDTO();
        dto.setCustomerId(customerId);
        dto.setUsableTotalBalance(((UserBalanceEntity)userBalanceFree.getValue()).getUsableTotalBalance());
        dto.setUsableStoreBalance(((UserBalanceEntity)userBalanceFree.getValue()).getUsableStoreBalance());
        dto.setUsableFreeBalance(((UserBalanceEntity)userBalanceFree.getValue()).getUsableFreeBalance());
        dto.setUsableGifBalance(((UserBalanceEntity)userBalanceFree.getValue()).getUsableGiftBalance());
        dto.setBalanceState(((UserBalanceEntity)userBalanceFree.getValue()).getBalanceState());
        UserBalanceDetailDTO detailDTO = new UserBalanceDetailDTO();
        ArrayList<UserBalanceDetailDTO.UserBalanceDetailRecordDTO> records = new ArrayList<UserBalanceDetailDTO.UserBalanceDetailRecordDTO>();
        UserBalanceDetailDTO.UserBalanceDetailRecordDTO detailRecordDTOStore = new UserBalanceDetailDTO.UserBalanceDetailRecordDTO();
        detailRecordDTOStore.setCash(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getDetailType() == 1 ? "+" : "-" + ((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getChangeMoney().toString());
        detailRecordDTOStore.setTime(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getCreateTime());
        detailRecordDTOStore.setWealth(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getAccountTotal().toString());
        detailRecordDTOStore.setTitle(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getDetailSubTypeDesc());
        records.add(detailRecordDTOStore);
        UserBalanceDetailDTO.UserBalanceDetailRecordDTO detailRecordDTOFree = new UserBalanceDetailDTO.UserBalanceDetailRecordDTO();
        detailRecordDTOFree.setCash(((UserBalanceDetailEntity)userBalanceDetailFree.getValue()).getDetailType() == 1 ? "+" : "-" + ((UserBalanceDetailEntity)userBalanceDetailFree.getValue()).getChangeMoney().toString());
        detailRecordDTOFree.setTime(((UserBalanceDetailEntity)userBalanceDetailFree.getValue()).getCreateTime());
        detailRecordDTOFree.setWealth(((UserBalanceDetailEntity)userBalanceDetailFree.getValue()).getAccountTotal().toString());
        detailRecordDTOFree.setTitle(((UserBalanceDetailEntity)userBalanceDetailFree.getValue()).getDetailSubTypeDesc());
        records.add(detailRecordDTOFree);
        detailDTO.setUserBalance(dto);
        detailDTO.setRecords(records);
        BalanceChangeDTO changeDTO = new BalanceChangeDTO();
        changeDTO.setUserBalanceDetail(detailDTO);
        changeDTO.setTotalBalanceChange(remainStoreAmount.add(remainFreeAmount));
        changeDTO.setStoreBalanceChange(remainStoreAmount);
        changeDTO.setFreeBalanceChange(remainFreeAmount);
        changeDTO.setGiftBalanceChange(BigDecimal.ZERO);
        return BaseJsonVo.success((Object)changeDTO);
    }

    @Transactional
    @Caching(evict={@CacheEvict(value={"Balance"}, key="'BalanceAccount:'+#customerId"), @CacheEvict(value={"Balance"}, key="'BalanceAccountDetail:'+#customerId")})
    public BaseJsonVo<BalanceChangeDTO> activeCharge(String customerId, BigDecimal increaseAmount, String detailSubTypeDesc, Boolean notice, String noticeText, String remark) {
        BaseJsonVo userBalance = this.userBalanceInterface.increaseAccount(customerId, increaseAmount, BalanceTypeEnum.FREE, customerId, 2);
        if (!userBalance.isSuccess()) {
            throw new RuntimeException(userBalance.getMessage());
        }
        BaseJsonVo userBalanceDetail = this.userBalanceDetailInterface.keepAccountDetail(DetailTypeEnum.ACTIVE_FREE, BalanceTypeEnum.FREE, customerId, increaseAmount, customerId, detailSubTypeDesc, ((UserBalanceEntity)userBalance.getValue()).getUsableTotalBalance(), ((UserBalanceEntity)userBalance.getValue()).getUsableStoreBalance(), ((UserBalanceEntity)userBalance.getValue()).getUsableFreeBalance(), ((UserBalanceEntity)userBalance.getValue()).getUsableGiftBalance(), remark);
        if (!userBalanceDetail.isSuccess()) {
            throw new RuntimeException(userBalanceDetail.getMessage());
        }
        BaseJsonVo userBalanceChange = this.userBalanceChangeInterface.keepAccountChange(((UserBalanceDetailEntity)userBalanceDetail.getValue()).getId(), increaseAmount, customerId);
        if (!userBalanceChange.isSuccess()) {
            throw new RuntimeException(userBalanceChange.getMessage());
        }
        BaseJsonVo cleanResult = this.cleanBalanceCache(customerId);
        if (!cleanResult.isSuccess()) {
            throw new RuntimeException(cleanResult.getMessage());
        }
        if (notice.booleanValue()) {
            // empty if block
        }
        UserBalanceDTO dto = new UserBalanceDTO();
        dto.setCustomerId(customerId);
        dto.setUsableTotalBalance(((UserBalanceEntity)userBalance.getValue()).getUsableTotalBalance());
        dto.setUsableStoreBalance(((UserBalanceEntity)userBalance.getValue()).getUsableStoreBalance());
        dto.setUsableFreeBalance(((UserBalanceEntity)userBalance.getValue()).getUsableFreeBalance());
        dto.setUsableGifBalance(((UserBalanceEntity)userBalance.getValue()).getUsableGiftBalance());
        dto.setBalanceState(((UserBalanceEntity)userBalance.getValue()).getBalanceState());
        UserBalanceDetailDTO detailDTO = new UserBalanceDetailDTO();
        UserBalanceDetailDTO.UserBalanceDetailRecordDTO detailRecordDTO = new UserBalanceDetailDTO.UserBalanceDetailRecordDTO();
        ArrayList<UserBalanceDetailDTO.UserBalanceDetailRecordDTO> records = new ArrayList<UserBalanceDetailDTO.UserBalanceDetailRecordDTO>();
        detailRecordDTO.setCash(((UserBalanceDetailEntity)userBalanceDetail.getValue()).getDetailType() == 1 ? "+" : "-" + ((UserBalanceDetailEntity)userBalanceDetail.getValue()).getChangeMoney().toString());
        detailRecordDTO.setTime(((UserBalanceDetailEntity)userBalanceDetail.getValue()).getCreateTime());
        detailRecordDTO.setWealth(((UserBalanceDetailEntity)userBalanceDetail.getValue()).getAccountTotal().toString());
        detailRecordDTO.setTitle(((UserBalanceDetailEntity)userBalanceDetail.getValue()).getDetailSubTypeDesc());
        records.add(detailRecordDTO);
        detailDTO.setUserBalance(dto);
        detailDTO.setRecords(records);
        BalanceChangeDTO changeDTO = new BalanceChangeDTO();
        changeDTO.setUserBalanceDetail(detailDTO);
        changeDTO.setTotalBalanceChange(increaseAmount);
        changeDTO.setStoreBalanceChange(BigDecimal.ZERO);
        changeDTO.setFreeBalanceChange(increaseAmount);
        changeDTO.setGiftBalanceChange(BigDecimal.ZERO);
        return BaseJsonVo.success((Object)changeDTO);
    }

    @Transactional
    @Caching(evict={@CacheEvict(value={"Balance"}, key="'BalanceAccount:'+#customerId"), @CacheEvict(value={"Balance"}, key="'BalanceAccountDetail:'+#customerId")})
    public BaseJsonVo<BalanceChangeDTO> increaseManual(@RedisLockParameter String customerId, BigDecimal increaseAmount, String operator, String detailSubTypeDesc) {
        BaseJsonVo userBalance = this.userBalanceInterface.increaseAccount(customerId, increaseAmount, BalanceTypeEnum.FREE, operator, 2);
        if (!userBalance.isSuccess()) {
            throw new RuntimeException(userBalance.getMessage());
        }
        BaseJsonVo userBalanceDetail = this.userBalanceDetailInterface.keepAccountDetail(DetailTypeEnum.MANUAL_INCREASE, BalanceTypeEnum.FREE, customerId, increaseAmount, operator, detailSubTypeDesc, ((UserBalanceEntity)userBalance.getValue()).getUsableTotalBalance(), ((UserBalanceEntity)userBalance.getValue()).getUsableStoreBalance(), ((UserBalanceEntity)userBalance.getValue()).getUsableFreeBalance(), ((UserBalanceEntity)userBalance.getValue()).getUsableGiftBalance(), "");
        if (!userBalanceDetail.isSuccess()) {
            throw new RuntimeException(userBalanceDetail.getMessage());
        }
        BaseJsonVo userBalanceChange = this.userBalanceChangeInterface.keepAccountChange(((UserBalanceDetailEntity)userBalanceDetail.getValue()).getId(), increaseAmount, operator);
        if (!userBalanceChange.isSuccess()) {
            throw new RuntimeException(userBalanceChange.getMessage());
        }
        BaseJsonVo cleanResult = this.cleanBalanceCache(customerId);
        if (!cleanResult.isSuccess()) {
            throw new RuntimeException(cleanResult.getMessage());
        }
        UserBalanceDTO dto = new UserBalanceDTO();
        dto.setCustomerId(customerId);
        dto.setUsableTotalBalance(((UserBalanceEntity)userBalance.getValue()).getUsableTotalBalance());
        dto.setUsableStoreBalance(((UserBalanceEntity)userBalance.getValue()).getUsableStoreBalance());
        dto.setUsableFreeBalance(((UserBalanceEntity)userBalance.getValue()).getUsableFreeBalance());
        dto.setUsableGifBalance(((UserBalanceEntity)userBalance.getValue()).getUsableGiftBalance());
        dto.setBalanceState(((UserBalanceEntity)userBalance.getValue()).getBalanceState());
        UserBalanceDetailDTO detailDTO = new UserBalanceDetailDTO();
        UserBalanceDetailDTO.UserBalanceDetailRecordDTO detailRecordDTO = new UserBalanceDetailDTO.UserBalanceDetailRecordDTO();
        ArrayList<UserBalanceDetailDTO.UserBalanceDetailRecordDTO> records = new ArrayList<UserBalanceDetailDTO.UserBalanceDetailRecordDTO>();
        detailRecordDTO.setCash(((UserBalanceDetailEntity)userBalanceDetail.getValue()).getDetailType() == 1 ? "+" : "-" + ((UserBalanceDetailEntity)userBalanceDetail.getValue()).getChangeMoney().toString());
        detailRecordDTO.setTime(((UserBalanceDetailEntity)userBalanceDetail.getValue()).getCreateTime());
        detailRecordDTO.setWealth(((UserBalanceDetailEntity)userBalanceDetail.getValue()).getAccountTotal().toString());
        detailRecordDTO.setTitle(((UserBalanceDetailEntity)userBalanceDetail.getValue()).getDetailSubTypeDesc());
        records.add(detailRecordDTO);
        detailDTO.setUserBalance(dto);
        detailDTO.setRecords(records);
        BalanceChangeDTO changeDTO = new BalanceChangeDTO();
        changeDTO.setUserBalanceDetail(detailDTO);
        changeDTO.setTotalBalanceChange(increaseAmount);
        changeDTO.setStoreBalanceChange(BigDecimal.ZERO);
        changeDTO.setFreeBalanceChange(increaseAmount);
        changeDTO.setGiftBalanceChange(BigDecimal.ZERO);
        return BaseJsonVo.success((Object)changeDTO);
    }

    @Transactional
    @Caching(evict={@CacheEvict(value={"Balance"}, key="'BalanceAccount:'+#customerId"), @CacheEvict(value={"Balance"}, key="'BalanceAccountDetail:'+#customerId")})
    public BaseJsonVo<BalanceChangeDTO> reduceManual(String customerId, BigDecimal reduceAmount, String operator, String remark) {
        String tradeNo = IDGenerate.getUniqueIdStr();
        UserBalanceEntity userBalanceEntity = this.userBalanceInterface.selectByCustomerId(customerId);
        if (userBalanceEntity == null || userBalanceEntity.getBalanceState() == 0) {
            throw new RuntimeException("\u8d26\u6237\u5df2\u5220\u9664");
        }
        if (userBalanceEntity.getBalanceState() == 2) {
            throw new RuntimeException("\u8d26\u6237\u5df2\u505c\u7528");
        }
        if (userBalanceEntity.getUsableTotalBalance().compareTo(reduceAmount) < 0) {
            throw new RuntimeException("\u4f59\u989d\u4e0d\u8db3");
        }
        BaseJsonVo changes = this.userBalanceChangeInterface.findChanges(customerId);
        if (!changes.isSuccess()) {
            throw new RuntimeException(changes.getMessage());
        }
        if (((List)changes.getValue()).stream().map(UserBalanceChangeEntity::getUsableMoney).reduce(BigDecimal.ZERO, BigDecimal::add).compareTo(userBalanceEntity.getUsableTotalBalance()) != 0) {
            throw new RuntimeException("\u8d26\u6237\u4f59\u989d\u4e0e\u5269\u4f59\u91d1\u989d\u4e0d\u7b26");
        }
        String detailId = IDGenerate.getUniqueIdStr();
        BigDecimal storeOrderAmount = BigDecimal.ZERO;
        BigDecimal giftOrderAmount = BigDecimal.ZERO;
        BigDecimal freeOrderAmount = BigDecimal.ZERO;
        BigDecimal remainOrderAmount = reduceAmount;
        for (UserBalanceChangeEntity change : (List)changes.getValue()) {
            UserBalanceDetailReleEntity rele;
            UserBalanceDetailEntity detail;
            if (remainOrderAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
            if (change.getUsableMoney().compareTo(remainOrderAmount) >= 0) {
                detail = (UserBalanceDetailEntity)this.userBalanceDetailInterface.selectByPrimaryKey((Serializable)((Object)change.getDetailId()));
                if (detail.getDetailSubType().intValue() == DetailTypeEnum.STORE.getValue()) {
                    storeOrderAmount = storeOrderAmount.add(remainOrderAmount);
                } else if (detail.getDetailSubType().intValue() == DetailTypeEnum.GIFT_CHARGE.getValue()) {
                    giftOrderAmount = giftOrderAmount.add(remainOrderAmount);
                } else {
                    freeOrderAmount = freeOrderAmount.add(remainOrderAmount);
                }
                this.userBalanceChangeInterface.consume(change.getDetailId(), operator, remainOrderAmount);
                rele = new UserBalanceDetailReleEntity();
                rele.setId(IDGenerate.getUniqueIdStr());
                rele.setExpendId(detailId);
                rele.setIncomeId(change.getDetailId());
                rele.setPayMoney(remainOrderAmount);
                rele.setCreateBy(operator);
                rele.setCreateTime(new Date());
                this.userBalanceDetailReleInterface.insert((Object)rele);
                remainOrderAmount = BigDecimal.ZERO;
                break;
            }
            detail = (UserBalanceDetailEntity)this.userBalanceDetailInterface.selectByPrimaryKey((Serializable)((Object)change.getDetailId()));
            if (detail.getDetailSubType().intValue() == DetailTypeEnum.STORE.getValue()) {
                storeOrderAmount = storeOrderAmount.add(change.getUsableMoney());
            } else if (detail.getDetailSubType().intValue() == DetailTypeEnum.GIFT_CHARGE.getValue()) {
                giftOrderAmount = giftOrderAmount.add(change.getUsableMoney());
            } else {
                freeOrderAmount = freeOrderAmount.add(change.getUsableMoney());
            }
            this.userBalanceChangeInterface.consume(change.getDetailId(), operator, change.getUsableMoney());
            rele = new UserBalanceDetailReleEntity();
            rele.setId(IDGenerate.getUniqueIdStr());
            rele.setExpendId(detailId);
            rele.setIncomeId(change.getDetailId());
            rele.setPayMoney(change.getUsableMoney());
            rele.setCreateBy(operator);
            rele.setCreateTime(new Date());
            this.userBalanceDetailReleInterface.insert((Object)rele);
            remainOrderAmount = remainOrderAmount.subtract(change.getUsableMoney());
        }
        if (storeOrderAmount.compareTo(BigDecimal.ZERO) > 0) {
            BaseJsonVo userBalanceStore = this.userBalanceInterface.decreaseAccount(customerId, storeOrderAmount, BalanceTypeEnum.STORE, operator, 2);
            if (!userBalanceStore.isSuccess()) {
                throw new RuntimeException(userBalanceStore.getMessage());
            }
            userBalanceEntity = (UserBalanceEntity)userBalanceStore.getValue();
        }
        if (giftOrderAmount.compareTo(BigDecimal.ZERO) > 0) {
            BaseJsonVo userBalanceGift = this.userBalanceInterface.decreaseAccount(customerId, giftOrderAmount, BalanceTypeEnum.GIFT, operator, 2);
            if (!userBalanceGift.isSuccess()) {
                throw new RuntimeException(userBalanceGift.getMessage());
            }
            userBalanceEntity = (UserBalanceEntity)userBalanceGift.getValue();
        }
        if (freeOrderAmount.compareTo(BigDecimal.ZERO) > 0) {
            BaseJsonVo userBalanceFree = this.userBalanceInterface.decreaseAccount(customerId, freeOrderAmount, BalanceTypeEnum.FREE, operator, 2);
            if (!userBalanceFree.isSuccess()) {
                throw new RuntimeException(userBalanceFree.getMessage());
            }
            userBalanceEntity = (UserBalanceEntity)userBalanceFree.getValue();
        }
        UserBalanceDetailEntity detailStore = new UserBalanceDetailEntity();
        detailStore.setId(detailId);
        detailStore.setCustomerId(customerId);
        detailStore.setDetailType(Integer.valueOf(DetailTypeEnum.MANUAL_DECREASE.getValue() / 1000));
        detailStore.setDetailSubType(Integer.valueOf(DetailTypeEnum.MANUAL_DECREASE.getValue()));
        detailStore.setDetailSubTypeDesc(DetailTypeEnum.MANUAL_DECREASE.getName());
        detailStore.setChangeMoney(reduceAmount);
        detailStore.setAccountTotal(userBalanceEntity.getUsableTotalBalance());
        detailStore.setAccountStore(userBalanceEntity.getUsableStoreBalance());
        detailStore.setAccountFree(userBalanceEntity.getUsableFreeBalance());
        detailStore.setAccountGift(userBalanceEntity.getUsableGiftBalance());
        detailStore.setTradeNo(tradeNo);
        detailStore.setCreateBy(operator);
        detailStore.setCreateTime(new Date());
        detailStore.setUpdateBy("");
        detailStore.setUpdateTime(null);
        detailStore.setRemark(remark);
        BaseJsonVo userBalanceDetailStore = this.userBalanceDetailInterface.keepAccountDetail(detailStore);
        if (!userBalanceDetailStore.isSuccess()) {
            throw new RuntimeException(userBalanceDetailStore.getMessage());
        }
        BaseJsonVo cleanResult = this.cleanBalanceCache(customerId);
        if (!cleanResult.isSuccess()) {
            throw new RuntimeException(cleanResult.getMessage());
        }
        UserBalanceDTO dto = new UserBalanceDTO();
        dto.setCustomerId(customerId);
        dto.setUsableTotalBalance(userBalanceEntity.getUsableTotalBalance());
        dto.setUsableStoreBalance(userBalanceEntity.getUsableStoreBalance());
        dto.setUsableFreeBalance(userBalanceEntity.getUsableFreeBalance());
        dto.setUsableGifBalance(userBalanceEntity.getUsableGiftBalance());
        dto.setBalanceState(userBalanceEntity.getBalanceState());
        UserBalanceDetailDTO detailDTO = new UserBalanceDetailDTO();
        ArrayList<UserBalanceDetailDTO.UserBalanceDetailRecordDTO> records = new ArrayList<UserBalanceDetailDTO.UserBalanceDetailRecordDTO>();
        UserBalanceDetailDTO.UserBalanceDetailRecordDTO detailRecordDTO = new UserBalanceDetailDTO.UserBalanceDetailRecordDTO();
        detailRecordDTO.setCash(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getDetailType() == 1 ? "+" : "-" + ((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getChangeMoney().toString());
        detailRecordDTO.setTime(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getCreateTime());
        detailRecordDTO.setWealth(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getAccountTotal().toString());
        detailRecordDTO.setTitle(((UserBalanceDetailEntity)userBalanceDetailStore.getValue()).getDetailSubTypeDesc());
        records.add(detailRecordDTO);
        detailDTO.setUserBalance(dto);
        detailDTO.setRecords(records);
        BalanceChangeDTO changeDTO = new BalanceChangeDTO();
        changeDTO.setUserBalanceDetail(detailDTO);
        changeDTO.setTotalBalanceChange(reduceAmount);
        changeDTO.setStoreBalanceChange(storeOrderAmount);
        changeDTO.setFreeBalanceChange(freeOrderAmount);
        changeDTO.setGiftBalanceChange(giftOrderAmount);
        return BaseJsonVo.success((Object)changeDTO);
    }

    private BaseJsonVo cleanBalanceCache(String customerId) {
        this.redis.remove("USER_BALANCE_DETAIL:" + customerId);
        this.redis.remove("USER_BALANCE_INFO:" + customerId);
        return BaseJsonVo.success((Object)"");
    }
}

