/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.balance.service.account;

import cc.lechun.balance.common.constants.BalanceTypeEnum;
import cc.lechun.balance.common.constants.DetailTypeEnum;
import cc.lechun.balance.entity.account.UserBalanceDetailEntity;
import cc.lechun.balance.entity.account.UserBalanceDetailEntityExample;
import cc.lechun.balance.iservice.account.UserBalanceDetailInterface;
import cc.lechun.balance.service.BaseService;
import cc.lechun.balance.service.account.UserBalanceDetailService;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.vo.BaseJsonVo;
import java.math.BigDecimal;
import java.util.Date;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserBalanceDetailService
extends BaseService<UserBalanceDetailEntity, String, UserBalanceDetailEntityExample>
implements UserBalanceDetailInterface {
    @Transactional
    public BaseJsonVo<UserBalanceDetailEntity> keepAccountDetail(DetailTypeEnum detailTypeEnum, BalanceTypeEnum balanceTypeEnum, String customerId, BigDecimal increaseAmount, String operator, String detailSubTypeDesc, BigDecimal usableTotalBalance, BigDecimal usableStoreBalance, BigDecimal usableFreeBalance, BigDecimal usableGiftBalance, String remark) {
        UserBalanceDetailEntity detail = new UserBalanceDetailEntity();
        detail.setId(IDGenerate.getUniqueIdStr());
        detail.setCustomerId(customerId);
        detail.setDetailType(Integer.valueOf(detailTypeEnum.getValue() / 1000));
        detail.setDetailSubType(Integer.valueOf(detailTypeEnum.getValue()));
        detail.setDetailSubTypeDesc(detailSubTypeDesc);
        detail.setChangeMoney(increaseAmount);
        detail.setAccountTotal(increaseAmount);
        detail.setAccountStore(new BigDecimal("0"));
        detail.setAccountFree(new BigDecimal("0"));
        detail.setAccountGift(new BigDecimal("0"));
        switch (1.$SwitchMap$cc$lechun$balance$common$constants$BalanceTypeEnum[balanceTypeEnum.ordinal()]) {
            case 1: {
                detail.setAccountStore(increaseAmount);
                break;
            }
            case 2: {
                detail.setAccountFree(increaseAmount);
                break;
            }
            case 3: {
                detail.setAccountGift(increaseAmount);
                break;
            }
        }
        detail.setTradeNo("");
        detail.setGiftId("");
        detail.setGiftTitle("");
        detail.setCreateBy(operator);
        detail.setCreateTime(new Date());
        detail.setUpdateBy("");
        detail.setUpdateTime(null);
        detail.setRemark("");
        return ((UserBalanceDetailService)this.getService((Object)this)).keepAccountDetail(detail);
    }

    public BaseJsonVo<UserBalanceDetailEntity> keepAccountDetail(UserBalanceDetailEntity detail) {
        if (this.insert((Object)detail) > 0) {
            return BaseJsonVo.success((Object)detail);
        }
        return BaseJsonVo.error((String)"\u4fdd\u5b58\u4f59\u989d\u53d8\u66f4\u8bb0\u5f55\u5931\u8d25");
    }
}

