/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.balance.service.account;

import cc.lechun.balance.common.constants.BalanceTypeEnum;
import cc.lechun.balance.dao.account.UserBalanceMapper;
import cc.lechun.balance.entity.account.UserBalanceEntity;
import cc.lechun.balance.entity.account.UserBalanceEntityExample;
import cc.lechun.balance.iservice.account.UserBalanceInterface;
import cc.lechun.balance.service.BaseService;
import cc.lechun.balance.service.account.UserBalanceService;
import cc.lechun.framework.common.vo.BaseJsonVo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserBalanceService
extends BaseService<UserBalanceEntity, String, UserBalanceEntityExample>
implements UserBalanceInterface {
    @Autowired
    UserBalanceMapper userBalanceMapper;

    public UserBalanceEntity selectByCustomerId(String customerId) {
        return (UserBalanceEntity)this.userBalanceMapper.selectByPrimaryKey((Serializable)((Object)customerId));
    }

    public BaseJsonVo<UserBalanceEntity> increaseAccount(String customerId, BigDecimal increaseAmount, BalanceTypeEnum balanceType, String operator, int increaseType) {
        UserBalanceEntity userBalanceEntity = (UserBalanceEntity)this.userBalanceMapper.selectByPrimaryKey((Serializable)((Object)customerId));
        if (userBalanceEntity == null) {
            userBalanceEntity = new UserBalanceEntity();
            userBalanceEntity.setCustomerId(customerId);
            userBalanceEntity.setBalanceState(Integer.valueOf(1));
            userBalanceEntity.setUsableTotalBalance(increaseAmount);
            switch (1.$SwitchMap$cc$lechun$balance$common$constants$BalanceTypeEnum[balanceType.ordinal()]) {
                case 1: {
                    userBalanceEntity.setUsableStoreBalance(increaseAmount);
                    userBalanceEntity.setTotalStoreBalance(increaseAmount);
                    break;
                }
                case 2: {
                    userBalanceEntity.setUsableFreeBalance(increaseAmount);
                    userBalanceEntity.setTotalFreeBalance(increaseAmount);
                    break;
                }
                case 3: {
                    userBalanceEntity.setUsableGiftBalance(increaseAmount);
                    userBalanceEntity.setTotalGiftBalance(increaseAmount);
                    break;
                }
            }
            userBalanceEntity.setCreateBy(operator);
            userBalanceEntity.setCreateTime(new Date());
            this.userBalanceMapper.insert((Object)userBalanceEntity);
        } else {
            Date updateTime = new Date();
            userBalanceEntity.setUpdateBy(operator);
            userBalanceEntity.setUpdateTime(updateTime);
            switch (1.$SwitchMap$cc$lechun$balance$common$constants$BalanceTypeEnum[balanceType.ordinal()]) {
                case 1: {
                    userBalanceEntity.setUsableStoreBalance(userBalanceEntity.getUsableStoreBalance().add(increaseAmount));
                    if (increaseType == 2) {
                        userBalanceEntity.setTotalStoreBalance(userBalanceEntity.getTotalStoreBalance().add(increaseAmount));
                    }
                    this.userBalanceMapper.increaseStore(customerId, increaseAmount, operator, updateTime, increaseType);
                    break;
                }
                case 2: {
                    userBalanceEntity.setUsableFreeBalance(userBalanceEntity.getUsableFreeBalance().add(increaseAmount));
                    if (increaseType == 2) {
                        userBalanceEntity.setTotalFreeBalance(userBalanceEntity.getTotalFreeBalance().add(increaseAmount));
                    }
                    this.userBalanceMapper.increaseFree(customerId, increaseAmount, operator, updateTime, increaseType);
                    break;
                }
                case 3: {
                    userBalanceEntity.setUsableGiftBalance(userBalanceEntity.getUsableGiftBalance().add(increaseAmount));
                    if (increaseType == 2) {
                        userBalanceEntity.setTotalGiftBalance(userBalanceEntity.getTotalGiftBalance().add(increaseAmount));
                    }
                    this.userBalanceMapper.increaseGift(customerId, increaseAmount, operator, updateTime, increaseType);
                    break;
                }
            }
        }
        userBalanceEntity.setUsableTotalBalance(userBalanceEntity.getUsableTotalBalance().add(increaseAmount));
        return BaseJsonVo.success((Object)userBalanceEntity);
    }

    public BaseJsonVo<UserBalanceEntity> decreaseAccount(String customerId, BigDecimal decreaseAmount, BalanceTypeEnum balanceType, String operator, int decreaseType) {
        UserBalanceEntity userBalanceEntity = (UserBalanceEntity)this.userBalanceMapper.selectByPrimaryKey((Serializable)((Object)customerId));
        if (userBalanceEntity == null) {
            return BaseJsonVo.error((String)"\u8d26\u6237\u4f59\u989d\u5f02\u5e38\uff1a\u8d26\u6237\u4e0d\u5b58\u5728");
        }
        if (userBalanceEntity.getUsableTotalBalance().compareTo(decreaseAmount) < 0) {
            return BaseJsonVo.error((String)"\u8d26\u6237\u4f59\u989d\u5f02\u5e38\uff1a\u8be5\u7528\u6237\u50a8\u503c\u5c0f\u4e8e\u8be5\u7b14\u50a8\u503c\u5269\u4f59");
        }
        if (decreaseAmount.compareTo(new BigDecimal("0")) <= 0) {
            BaseJsonVo.success((Object)userBalanceEntity);
        }
        Date updateTime = new Date();
        userBalanceEntity.setUpdateBy(operator);
        userBalanceEntity.setUpdateTime(updateTime);
        switch (1.$SwitchMap$cc$lechun$balance$common$constants$BalanceTypeEnum[balanceType.ordinal()]) {
            case 1: {
                userBalanceEntity.setUsableStoreBalance(userBalanceEntity.getUsableStoreBalance().subtract(decreaseAmount));
                if (decreaseType == 1) {
                    userBalanceEntity.setTotalStoreBalance(userBalanceEntity.getTotalStoreBalance().subtract(decreaseAmount));
                }
                this.userBalanceMapper.decreaseStore(customerId, decreaseAmount, operator, updateTime, decreaseType);
                break;
            }
            case 2: {
                userBalanceEntity.setUsableFreeBalance(userBalanceEntity.getUsableFreeBalance().subtract(decreaseAmount));
                if (decreaseType == 1) {
                    userBalanceEntity.setTotalFreeBalance(userBalanceEntity.getTotalFreeBalance().subtract(decreaseAmount));
                }
                this.userBalanceMapper.decreaseFree(customerId, decreaseAmount, operator, updateTime, decreaseType);
                break;
            }
            case 3: {
                userBalanceEntity.setUsableGiftBalance(userBalanceEntity.getUsableGiftBalance().subtract(decreaseAmount));
                if (decreaseType == 1) {
                    userBalanceEntity.setTotalGiftBalance(userBalanceEntity.getTotalGiftBalance().subtract(decreaseAmount));
                }
                this.userBalanceMapper.decreaseGift(customerId, decreaseAmount, operator, updateTime, decreaseType);
                break;
            }
        }
        userBalanceEntity.setUsableTotalBalance(userBalanceEntity.getUsableTotalBalance().subtract(decreaseAmount));
        return BaseJsonVo.success((Object)userBalanceEntity);
    }
}

