/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.balance.service.gift;

import cc.lechun.balance.dao.gift.GiftCardMapper;
import cc.lechun.balance.entity.gift.GiftCardEntity;
import cc.lechun.balance.entity.gift.GiftCardEntityExample;
import cc.lechun.balance.iservice.gift.GiftCardInterface;
import cc.lechun.balance.service.BaseService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GiftCardService
extends BaseService<GiftCardEntity, String, GiftCardEntityExample>
implements GiftCardInterface {
    @Autowired
    private GiftCardMapper giftCardMapper;

    public PageInfo queryGiftCardByBatchId(int currentPage, int pageSize, GiftCardEntity giftCardEntity) {
        Page page = PageHelper.startPage((int)currentPage, (int)pageSize);
        List giftCardEntityList = this.giftCardMapper.getGiftCardInfoList(giftCardEntity);
        PageInfo pg = page.toPageInfo();
        pg.setList(giftCardEntityList);
        return pg;
    }

    public void saveGiftCardByBatchId(List<GiftCardEntity> giftCardEntityList) {
        this.giftCardMapper.batchInsert(giftCardEntityList);
    }

    public List<GiftCardEntity> queryCardInfo(String batchNo) {
        GiftCardEntity giftCardEntity = new GiftCardEntity();
        giftCardEntity.setBatchNo(batchNo);
        List giftCardEntityList = this.giftCardMapper.getGiftCardInfoList(giftCardEntity);
        return giftCardEntityList;
    }

    public List<GiftCardEntity> queryCardInfoByBatchNo(String batchNo, int cardState) {
        GiftCardEntity giftCardEntity = new GiftCardEntity();
        giftCardEntity.setBatchNo(batchNo);
        giftCardEntity.setCardState(Integer.valueOf(cardState));
        List giftCardEntityList = this.giftCardMapper.getGiftCardInfoList(giftCardEntity);
        return giftCardEntityList;
    }

    public List<GiftCardEntity> queryCardInfoByBatchNoOne(String batchNo, int cardState) {
        GiftCardEntity giftCardEntity = new GiftCardEntity();
        giftCardEntity.setBatchNo(batchNo);
        giftCardEntity.setCardState(Integer.valueOf(cardState));
        List giftCardEntityList = this.giftCardMapper.queryGiftCardInfoListByNotOne(giftCardEntity);
        return giftCardEntityList;
    }

    public void batchDeleteCardInfoByBatchNo(String batchNo) {
        String[] batchNoArr = new String[]{batchNo};
        this.giftCardMapper.batchDelete((Serializable[])batchNoArr);
    }

    public int batchCancel(String[] cardNoArry) {
        return this.giftCardMapper.batchCancel(cardNoArry);
    }

    public List<GiftCardEntity> queryGiftCardInfoListByNotOne(GiftCardEntity giftCardEntity) {
        return this.giftCardMapper.queryGiftCardInfoListByNotOne(giftCardEntity);
    }

    public int updateCardState(GiftCardEntity giftCardEntity) {
        return this.giftCardMapper.updateCardState(giftCardEntity);
    }

    public List<GiftCardEntity> queryGiftCardInfo(GiftCardEntity giftCardEntity) {
        return this.giftCardMapper.getGiftCardInfoList(giftCardEntity);
    }
}

